/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.jcodec;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class ImplConvertJCodecPicture {
    public static void RGB_to_PLU8(Picture input, Planar<GrayU8> output) {
        if (input.getColor() != ColorSpace.RGB) {
            throw new RuntimeException("Unexpected input color space!");
        }
        if (output.getNumBands() != 3) {
            throw new RuntimeException("Unexpected number of bands in output image!");
        }
        output.reshape(input.getWidth(), input.getHeight());
        byte[] dataIn = input.getData()[0];
        GrayU8 out0 = (GrayU8)output.getBand(0);
        GrayU8 out1 = (GrayU8)output.getBand(1);
        GrayU8 out2 = (GrayU8)output.getBand(2);
        int indexIn = 0;
        int indexOut = 0;
        for (int i = 0; i < output.height; ++i) {
            int j = 0;
            while (j < output.width) {
                byte r = dataIn[indexIn++];
                byte g = dataIn[indexIn++];
                byte b = dataIn[indexIn++];
                out2.data[indexOut] = r;
                out1.data[indexOut] = g;
                out0.data[indexOut] = b;
                ++j;
                ++indexOut;
            }
        }
    }

    public static void yuv420_to_PlRgb_U8(Picture input, Planar<GrayU8> output) {
        byte[] Y = input.getPlaneData(0);
        byte[] U = input.getPlaneData(1);
        byte[] V = input.getPlaneData(2);
        GrayU8 R = (GrayU8)output.getBand(0);
        GrayU8 G = (GrayU8)output.getBand(1);
        GrayU8 B = (GrayU8)output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexUV = row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * (Y[indexY++] + 128) - 16;
                byte cr = U[indexUV];
                byte cb = V[indexUV];
                if (y < 0) {
                    y = 0;
                }
                int b = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int r = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = (byte)r;
                G.data[indexOut] = (byte)g;
                B.data[indexOut] = (byte)b;
                indexUV += col & 1;
                ++col;
                ++indexOut;
            }
        }
    }

    public static void yuv420_to_PlRgb_F32(Picture input, Planar<GrayF32> output) {
        byte[] Y = input.getPlaneData(0);
        byte[] U = input.getPlaneData(1);
        byte[] V = input.getPlaneData(2);
        GrayF32 R = (GrayF32)output.getBand(0);
        GrayF32 G = (GrayF32)output.getBand(1);
        GrayF32 B = (GrayF32)output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexUV = row / 2 * uvStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * (Y[indexY++] + 128) - 16;
                byte cr = U[indexUV];
                byte cb = V[indexUV];
                if (y < 0) {
                    y = 0;
                }
                int b = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int r = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = r;
                G.data[indexOut] = g;
                B.data[indexOut] = b;
                indexUV += col & 1;
                ++col;
                ++indexOut;
            }
        }
    }

    public static void yuv420_to_U8(Picture input, GrayU8 output) {
        byte[] Y = input.getPlaneData(0);
        int yStride = output.width;
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y;
                if ((y = 1191 * (Y[indexY++] + 128) - 16) < 0) {
                    y = 0;
                }
                if ((y >>= 10) < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                output.data[indexOut] = (byte)y;
                ++col;
                ++indexOut;
            }
        }
    }

    public static void yuv420_to_F32(Picture input, GrayF32 output) {
        byte[] Y = input.getPlaneData(0);
        int yStride = output.width;
        for (int row = 0; row < output.height; ++row) {
            int indexY = row * yStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y;
                if ((y = 1191 * (Y[indexY++] + 128) - 16) < 0) {
                    y = 0;
                }
                if ((y >>= 10) < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                output.data[indexOut] = y;
                ++col;
                ++indexOut;
            }
        }
    }
}

