/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.jcodec;

import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.jcodec.UtilJCodec;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.ddogleg.struct.DogArray;
import org.jcodec.api.FrameGrab;
import org.jcodec.api.JCodecException;
import org.jcodec.api.PictureWithMetadata;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Picture;

public class JCodecSimplified<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    private static final int REORDER_LENGTH = 5;
    FrameGrab grabber;
    T image;
    ImageType<T> typeOutput;
    DogArray<PictureInfo> reorder = new DogArray(() -> new PictureInfo());
    int width;
    int height;
    boolean endOfFile = false;
    int frame = -1;
    String filename;

    public JCodecSimplified(String filename, ImageType<T> typeOutput) {
        this.image = typeOutput.createImage(1, 1);
        this.typeOutput = typeOutput;
        this.filename = filename;
        this.reset();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasNext() {
        return this.reorder.size > 0;
    }

    public T next() {
        PictureInfo best = (PictureInfo)this.reorder.get(0);
        int bestIndex = 0;
        for (int i = 1; i < this.reorder.size; ++i) {
            PictureInfo p = (PictureInfo)this.reorder.get(i);
            if (!(best.timestamp > p.timestamp)) continue;
            best = p;
            bestIndex = i;
        }
        UtilJCodec.convertToBoof(best.picture, this.image);
        this.reorder.removeSwap(bestIndex);
        if (!this.endOfFile) {
            try {
                this.grabAndCopy((PictureInfo)this.reorder.grow());
            }
            catch (Exception e) {
                this.reorder.removeTail();
                this.endOfFile = true;
            }
        }
        ++this.frame;
        return this.image;
    }

    public T getImage() {
        return this.image;
    }

    public <InternalImage> InternalImage getGuiImage() {
        BufferedImage output = new BufferedImage(((ImageBase)this.image).width, ((ImageBase)this.image).height, 1);
        ConvertBufferedImage.convertTo(this.image, (BufferedImage)output, (boolean)true);
        return (InternalImage)output;
    }

    public void close() {
    }

    public int getFrameNumber() {
        return this.frame;
    }

    public void setLoop(boolean loop) {
    }

    public ImageType<T> getImageType() {
        return this.typeOutput;
    }

    public void reset() {
        this.filename = UtilIO.checkIfJarAndCopyToTemp((String)this.filename);
        try {
            this.grabber = FrameGrab.createFrameGrab((SeekableByteChannel)NIOUtils.readableChannel((File)new File(this.filename)));
        }
        catch (IOException | JCodecException e) {
            throw new RuntimeException(e);
        }
        this.frame = -1;
        this.endOfFile = false;
        while (this.reorder.size < 5) {
            try {
                this.grabAndCopy((PictureInfo)this.reorder.grow());
            }
            catch (IOException e) {
                this.reorder.removeTail();
                this.endOfFile = true;
                break;
            }
        }
        if (this.reorder.size > 0) {
            PictureInfo p = (PictureInfo)this.reorder.get(0);
            this.width = p.picture.getWidth();
            this.height = p.picture.getHeight();
        }
    }

    private void grabAndCopy(PictureInfo info) throws IOException {
        PictureWithMetadata p = this.grabber.getNativeFrameWithMetadata();
        if (info.picture == null || !info.picture.compatible(p.getPicture())) {
            info.picture = p.getPicture().cloneCropped();
        } else {
            info.picture.copyFrom(p.getPicture());
        }
        info.timestamp = p.getTimestamp();
    }

    private static class PictureInfo {
        Picture picture;
        double timestamp;

        private PictureInfo() {
        }
    }
}

