/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.jcodec;

import boofcv.io.jcodec.ImplConvertJCodecPicture;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.Planar;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class UtilJCodec {
    public static void convertToBoof(Picture input, ImageBase output) {
        output.reshape(input.getWidth(), input.getHeight());
        if (input.getColor() == ColorSpace.RGB) {
            ImplConvertJCodecPicture.RGB_to_PLU8(input, (Planar<GrayU8>)((Planar)output));
        } else if (input.getColor() == ColorSpace.YUV420) {
            if (output instanceof Planar) {
                Planar ms = (Planar)output;
                if (ms.getImageType().getDataType() == ImageDataType.U8) {
                    ImplConvertJCodecPicture.yuv420_to_PlRgb_U8(input, (Planar<GrayU8>)ms);
                } else if (ms.getImageType().getDataType() == ImageDataType.F32) {
                    ImplConvertJCodecPicture.yuv420_to_PlRgb_F32(input, (Planar<GrayF32>)ms);
                }
            } else if (output instanceof GrayU8) {
                ImplConvertJCodecPicture.yuv420_to_U8(input, (GrayU8)output);
            } else if (output instanceof GrayF32) {
                ImplConvertJCodecPicture.yuv420_to_F32(input, (GrayF32)output);
            } else {
                throw new RuntimeException("Unexpected output image type");
            }
        }
    }
}

