/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.scene.nister2006;

import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.SceneRecognition;
import boofcv.abst.scene.nister2006.ConfigRecognitionNister2006;
import boofcv.alg.scene.bow.BowMatch;
import boofcv.alg.scene.nister2006.LearnNodeWeights;
import boofcv.alg.scene.nister2006.RecognitionVocabularyTreeNister2006;
import boofcv.alg.scene.vocabtree.HierarchicalVocabularyTree;
import boofcv.alg.scene.vocabtree.LearnHierarchicalTree;
import boofcv.factory.struct.FactoryTupleDesc;
import boofcv.misc.BoofLambdas;
import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.kmeans.FactoryTupleCluster;
import georegression.struct.packed.PackedArray;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class FeatureSceneRecognitionNister2006<TD extends TupleDesc<TD>>
implements FeatureSceneRecognition<TD> {
    ConfigRecognitionNister2006 config;
    HierarchicalVocabularyTree<TD> tree;
    RecognitionVocabularyTreeNister2006<TD> database;
    DogArray<TD> imageFeatures;
    List<String> imageIds = new ArrayList<String>();
    public int minimumForThread = 500;
    Class<TD> tupleType;
    int tupleDOF;
    @Nullable
    PrintStream verbose;
    long timeLearnDescribeMS;
    long timeLearnClusterMS;
    long timeLearnWeightsMS;

    public FeatureSceneRecognitionNister2006(ConfigRecognitionNister2006 config, Factory<TD> factory) {
        this.config = config;
        this.imageFeatures = new DogArray(factory);
        this.database = new RecognitionVocabularyTreeNister2006();
        this.database.setDistanceType(config.distanceNorm);
        this.database.minimumDepthFromRoot = config.minimumDepthFromRoot;
        this.database.maximumQueryImagesInNode.setTo(config.queryMaximumImagesInNode);
        this.tupleDOF = ((TupleDesc)this.imageFeatures.grow()).size();
        this.tupleType = ((TupleDesc)this.imageFeatures.get(0)).getClass();
    }

    public void setDatabase(RecognitionVocabularyTreeNister2006<TD> db) {
        this.database = db;
        this.tree = db.getTree();
    }

    @Override
    public void learnModel(Iterator<FeatureSceneRecognition.Features<TD>> images) {
        PackedTupleArray packedFeatures = FactoryTupleDesc.createPackedBig((int)this.tupleDOF, this.tupleType);
        DogArray_I32 startIndex = new DogArray_I32();
        long time0 = System.currentTimeMillis();
        while (images.hasNext()) {
            FeatureSceneRecognition.Features<TD> image = images.next();
            startIndex.add(packedFeatures.size());
            int N = image.size();
            packedFeatures.reserve(N);
            for (int i = 0; i < N; ++i) {
                packedFeatures.append(image.getDescription(i));
            }
            if (this.verbose == null) continue;
            this.verbose.println("described.size=" + startIndex.size + " features=" + N + " packed.size=" + packedFeatures.size());
        }
        startIndex.add(packedFeatures.size());
        if (this.verbose != null) {
            this.verbose.println("packedFeatures.size=" + packedFeatures.size());
        }
        long time1 = System.currentTimeMillis();
        PackedTupleArray packedArray = FactoryTupleDesc.createPackedBig((int)this.tupleDOF, this.tupleType);
        this.tree = new HierarchicalVocabularyTree<TD>(FactoryTupleCluster.createDistance(this.tupleType), packedArray);
        this.tree.branchFactor = this.config.tree.branchFactor;
        this.tree.maximumLevel = this.config.tree.maximumLevel;
        if (this.verbose != null) {
            this.verbose.println("learning the tree");
        }
        BoofLambdas.Factory factoryKMeans = () -> FactoryTupleCluster.kmeans(this.config.kmeans, this.minimumForThread, this.tupleDOF, this.tupleType);
        LearnHierarchicalTree<TD> learnTree = new LearnHierarchicalTree<TD>(() -> FactoryTupleDesc.createPackedBig((int)this.tupleDOF, this.tupleType), factoryKMeans, this.config.randSeed);
        learnTree.minimumPointsForChildren.setTo(this.config.learningMinimumPointsForChildren);
        if (this.verbose != null) {
            VerboseUtils.verboseChildren((PrintStream)this.verbose, null, (VerbosePrint[])new VerbosePrint[]{learnTree});
        }
        learnTree.process((PackedArray<TD>)packedFeatures, this.tree);
        long time2 = System.currentTimeMillis();
        if (this.verbose != null) {
            this.verbose.println("Tree {bf=" + this.tree.branchFactor + " ml=" + this.tree.maximumLevel + " nodes.size=" + this.tree.nodes.size + "}");
        }
        if (this.verbose != null) {
            this.verbose.println("learning the weights");
        }
        if (this.config.learnNodeWeights) {
            LearnNodeWeights<TD> learnWeights = new LearnNodeWeights<TD>();
            learnWeights.maximumNumberImagesInNode.setTo(this.config.learningMaximumImagesInNode);
            learnWeights.reset(this.tree);
            for (int imgIdx = 1; imgIdx < startIndex.size; ++imgIdx) {
                this.imageFeatures.reset();
                int idx0 = startIndex.get(imgIdx - 1);
                int idx1 = startIndex.get(imgIdx);
                for (int i = idx0; i < idx1; ++i) {
                    ((TupleDesc)this.imageFeatures.grow()).setTo((TupleDesc)packedFeatures.getTemp(i));
                }
                learnWeights.addImage(this.imageFeatures.toList());
            }
            learnWeights.fixate();
        } else {
            this.tree.nodes.forEach(n -> {
                n.weight = 1.0;
            });
            ((HierarchicalVocabularyTree.Node)this.tree.nodes.get((int)0)).weight = 0.0;
        }
        long time3 = System.currentTimeMillis();
        this.database.initializeTree(this.tree);
        this.timeLearnDescribeMS = time1 - time0;
        this.timeLearnClusterMS = time2 - time1;
        this.timeLearnWeightsMS = time3 - time2;
        if (this.verbose != null) {
            this.verbose.printf("Time (s): describe=%.1f cluster=%.1f weights=%.1f\n", (double)this.timeLearnDescribeMS * 0.001, (double)this.timeLearnClusterMS * 0.001, (double)this.timeLearnWeightsMS * 0.001);
        }
    }

    @Override
    public void clearDatabase() {
        this.imageIds.clear();
        this.database.clearImages();
    }

    @Override
    public void addImage(String id, FeatureSceneRecognition.Features<TD> features) {
        this.imageFeatures.resize(features.size());
        for (int i = 0; i < this.imageFeatures.size; ++i) {
            ((TupleDesc)this.imageFeatures.get(i)).setTo(features.getDescription(i));
        }
        int imageIndex = this.imageIds.size();
        this.imageIds.add(id);
        if (this.verbose != null) {
            this.verbose.println("added[" + imageIndex + "].size=" + features.size() + " id=" + id);
        }
        this.database.addImage(imageIndex, this.imageFeatures.toList());
    }

    @Override
    public List<String> getImageIds(@Nullable List<String> storage) {
        if (storage == null) {
            storage = new ArrayList<String>();
        } else {
            storage.clear();
        }
        storage.addAll(this.imageIds);
        return storage;
    }

    @Override
    public boolean query(FeatureSceneRecognition.Features<TD> query, @Nullable BoofLambdas.Filter<String> filter, int limit, DogArray<SceneRecognition.Match> matches) {
        BoofLambdas.FilterInt filterInt;
        matches.resize(0);
        limit = limit <= 0 ? Integer.MAX_VALUE : limit;
        this.imageFeatures.resize(query.size());
        for (int i = 0; i < this.imageFeatures.size; ++i) {
            ((TupleDesc)this.imageFeatures.get(i)).setTo(query.getDescription(i));
        }
        BoofLambdas.FilterInt filterInt2 = filterInt = filter == null ? null : index -> filter.keep((Object)this.imageIds.get(index));
        if (!this.database.query(this.imageFeatures.toList(), filterInt, limit)) {
            return false;
        }
        DogArray<BowMatch> found = this.database.getMatches();
        if (this.verbose != null) {
            this.verbose.println("matches.size=" + found.size + " best.error=" + ((BowMatch)found.get((int)0)).error);
        }
        matches.resize(found.size);
        for (int i = 0; i < matches.size; ++i) {
            BowMatch f = (BowMatch)found.get(i);
            ((SceneRecognition.Match)matches.get((int)i)).id = this.imageIds.get(f.identification);
            ((SceneRecognition.Match)matches.get((int)i)).error = f.error;
        }
        return !matches.isEmpty();
    }

    @Override
    public int getQueryWord(int featureIdx) {
        return this.traverseUpGetID(this.database.getFeatureIdxToLeafID().get(featureIdx), this.config.featureSingleWordHops);
    }

    @Override
    public void getQueryWords(int featureIdx, DogArray_I32 words) {
        int leafID = this.getQueryWord(featureIdx);
        this.lookupWordsFromLeafID(leafID, words);
    }

    @Override
    public int lookupWord(TD description) {
        return this.traverseUpGetID(this.database.tree.searchPathToLeaf(description, (BoofLambdas.ProcessIndex<HierarchicalVocabularyTree.Node>)((BoofLambdas.ProcessIndex)(idx, n) -> {})), this.config.featureSingleWordHops);
    }

    @Override
    public void lookupWords(TD description, DogArray_I32 word) {
        this.lookupWordsFromLeafID(this.lookupWord(description), word);
    }

    protected void lookupWordsFromLeafID(int leafID, DogArray_I32 word) {
        word.reset();
        HierarchicalVocabularyTree.Node node = (HierarchicalVocabularyTree.Node)this.database.tree.nodes.get(leafID);
        while (node != null && node.parent != -1) {
            word.add(node.index);
            node = (HierarchicalVocabularyTree.Node)this.database.tree.nodes.get(node.parent);
        }
    }

    protected int traverseUpGetID(int id, int maxHops) {
        int hops = maxHops;
        HierarchicalVocabularyTree.Node node = (HierarchicalVocabularyTree.Node)this.database.tree.nodes.get(id);
        while (hops-- > 0) {
            node = (HierarchicalVocabularyTree.Node)this.database.tree.nodes.get(node.parent);
            if (node.parent == -1) break;
            id = node.index;
        }
        return id;
    }

    @Override
    public int getTotalWords() {
        return this.database.tree.nodes.size;
    }

    @Override
    public Class<TD> getDescriptorType() {
        return this.tupleType;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> set) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public ConfigRecognitionNister2006 getConfig() {
        return this.config;
    }

    public HierarchicalVocabularyTree<TD> getTree() {
        return this.tree;
    }

    public RecognitionVocabularyTreeNister2006<TD> getDatabase() {
        return this.database;
    }

    public DogArray<TD> getImageFeatures() {
        return this.imageFeatures;
    }

    public void setImageFeatures(DogArray<TD> imageFeatures) {
        this.imageFeatures = imageFeatures;
    }

    public List<String> getImageIds() {
        return this.imageIds;
    }

    public int getMinimumForThread() {
        return this.minimumForThread;
    }

    public void setMinimumForThread(int minimumForThread) {
        this.minimumForThread = minimumForThread;
    }

    public long getTimeLearnDescribeMS() {
        return this.timeLearnDescribeMS;
    }

    public long getTimeLearnClusterMS() {
        return this.timeLearnClusterMS;
    }

    public long getTimeLearnWeightsMS() {
        return this.timeLearnWeightsMS;
    }
}

