/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecPyramid;
import boofcv.alg.fiducial.aztec.GridToPixelHelper;
import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.qrcode.SquareLocatorPatternDetectorBase;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.struct.image.ImageGray;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class AztecFinderPatternDetector<T extends ImageGray<T>>
extends SquareLocatorPatternDetectorBase<T> {
    public double minimumTemplateMatch = 0.8;
    public double distanceTolerance = 0.15;
    private final DogArray<Layer> layers = new DogArray(Layer::new, Layer::reset);
    private final DogArray<AztecPyramid> found = new DogArray(AztecPyramid::new, AztecPyramid::reset);
    private final NearestNeighbor<Layer> nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new SquareNode.KdTreeSquareNode());
    private final NearestNeighbor.Search<Layer> search = this.nn.createSearch();
    private final DogArray<NnData<Layer>> searchResults = new DogArray(NnData::new);
    GridToPixelHelper gridToPixel = new GridToPixelHelper();
    Point2D_F64 pixel = new Point2D_F64();

    public AztecFinderPatternDetector(DetectPolygonBinaryGrayRefine<T> squareDetector) {
        super(squareDetector);
        this.maxContourFraction = 2.0;
    }

    @Override
    protected void findLocatorPatternsFromSquares() {
        this.layers.reset();
        this.found.reset();
        this.squaresToLayerList();
        this.findLayersInsideOfLayers();
        this.createPyramids();
    }

    void squaresToLayerList() {
        List infoList = this.squareDetector.getPolygonInfo();
        for (int i = 0; i < infoList.size(); ++i) {
            DetectPolygonFromContour.Info info = (DetectPolygonFromContour.Info)infoList.get(i);
            double grayThreshold = (info.edgeInside + info.edgeOutside) / 2.0;
            int diameter = this.computeLayerDiameter(info.polygon, (float)grayThreshold);
            if (diameter <= 0) continue;
            this.squareDetector.refine(info);
            Layer pp = (Layer)this.layers.grow();
            pp.square = info.polygon;
            pp.threshold = grayThreshold;
            pp.diameter = diameter;
            SquareGraph.computeNodeInfo(pp);
        }
    }

    void findLayersInsideOfLayers() {
        this.nn.setPoints(this.layers.toList(), false);
        for (int layerIdx = 0; layerIdx < this.layers.size; ++layerIdx) {
            Layer a = (Layer)this.layers.get(layerIdx);
            this.search.findNearest((Object)a, a.largestSide / 2.0, 10, this.searchResults);
            for (int searchIdx = 0; searchIdx < this.searchResults.size; ++searchIdx) {
                NnData result = (NnData)this.searchResults.get(searchIdx);
                Layer b = (Layer)result.point;
                if (a == b || b.largestSide > a.largestSide) continue;
                double maxSide = Math.max(a.largestSide, b.largestSide);
                double distance = a.center.distance((GeoTuple2D_F64)b.center);
                if (distance > maxSide * this.distanceTolerance) continue;
                b.child = true;
                a.children.add(b);
                if (this.verbose == null) continue;
                this.verbose.printf("%s child of %s\n", AztecFinderPatternDetector.format(a), AztecFinderPatternDetector.format(b));
            }
        }
    }

    private static String format(Layer a) {
        return String.format("(%.1f %.1f, s=%d)", a.center.x, a.center.y, a.diameter);
    }

    void createPyramids() {
        for (int layerIdx = 0; layerIdx < this.layers.size; ++layerIdx) {
            Layer a = (Layer)this.layers.get(layerIdx);
            if (a.child || a.children.size() > 1 || a.children.isEmpty() == (a.diameter == 9)) continue;
            AztecPyramid p = (AztecPyramid)this.found.grow();
            this.copyToOutput(a, (AztecPyramid.Layer)p.layers.grow());
            for (int i = 0; i < a.children.size(); ++i) {
                this.copyToOutput(a.children.get(i), (AztecPyramid.Layer)p.layers.grow());
            }
            p.alignCorners();
        }
    }

    void copyToOutput(Layer src, AztecPyramid.Layer dst) {
        dst.square.setTo(src.square);
        dst.center.setTo(src.center);
        dst.threshold = src.threshold;
    }

    int computeLayerDiameter(Polygon2D_F64 polygon, float threshold) {
        double score5 = this.scoreTemplate(polygon, threshold, 5);
        double score9 = this.scoreTemplate(polygon, threshold, 9);
        if (score5 < this.minimumTemplateMatch && score9 < this.minimumTemplateMatch) {
            return 0;
        }
        return score5 > score9 ? 5 : 9;
    }

    double scoreTemplate(Polygon2D_F64 polygon, float threshold, int squaresWide) {
        this.gridToPixel.initOriginCenter(polygon, squaresWide);
        int radius = (squaresWide - 2) / 2;
        int numMatches = 0;
        for (int row = -radius; row <= radius; ++row) {
            int rrow = Math.abs(row);
            for (int col = -radius; col <= radius; ++col) {
                int rcol = Math.abs(col);
                this.gridToPixel.convert(col, row, this.pixel);
                float pixelValue = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
                int r = Math.max(rrow, rcol);
                if (pixelValue > threshold != (r % 2 == 1)) continue;
                ++numMatches;
            }
        }
        int numSamples = (radius * 2 + 1) * (radius * 2 + 1);
        double fitFraction = (double)numMatches / (double)numSamples;
        if (this.verbose != null) {
            this.verbose.printf("poly_sore: p[0]=(%.1f %.1f) template: score=%.2f squares=%d pixels=%.1f\n", polygon.get((int)0).x, polygon.get((int)1).y, fitFraction, squaresWide, polygon.getSideLength(0));
        }
        return fitFraction;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> set) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public DogArray<AztecPyramid> getFound() {
        return this.found;
    }

    public static class Layer
    extends SquareNode {
        public int diameter;
        public double threshold;
        public boolean child;
        public List<Layer> children = new ArrayList<Layer>();

        @Override
        public void reset() {
            super.reset();
            this.diameter = -1;
            this.threshold = 0.0;
            this.child = false;
            this.children.clear();
        }
    }
}

