/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.drawing.FiducialImageEngine;
import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecMessageModeCodec;
import boofcv.alg.fiducial.aztec.AztecPyramid;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import georegression.struct.packed.PackedArrayPoint2D_I16;
import georegression.struct.point.Point2D_I16;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AztecGenerator {
    public double markerWidth = 1.0;
    protected int lengthInSquares;
    protected double squareWidth;
    protected int orientationSquareCount;
    protected double orientationLoc;
    @Nullable
    protected FiducialRenderEngine render;
    protected PackedArrayPoint2D_I16 messageCoordiantes = new PackedArrayPoint2D_I16();
    protected Point2D_I16 coordinate = new Point2D_I16();
    AztecMessageModeCodec codecMode = new AztecMessageModeCodec();
    PackedBits8 bits = new PackedBits8();

    public static GrayU8 renderImage(int pixelPerSquare, int border, AztecCode marker) {
        int numSquares = marker.getMarkerWidthSquares();
        FiducialImageEngine render = new FiducialImageEngine();
        render.configure(pixelPerSquare * border, numSquares * pixelPerSquare);
        new AztecGenerator().setMarkerWidth(numSquares * pixelPerSquare).setRender(render).render(marker);
        for (AztecPyramid.Layer layer : marker.locator.layers.toList()) {
            layer.threshold = (double)(render.getWhite() + render.getBlack()) / 2.0;
        }
        return render.getGray();
    }

    public AztecGenerator render(AztecCode marker) {
        this.lengthInSquares = marker.getMarkerWidthSquares();
        this.squareWidth = this.markerWidth / (double)this.lengthInSquares;
        Objects.requireNonNull(this.render, "You must set 'render' field first.").init();
        this.orientationSquareCount = marker.getLocatorWidthSquares() + 4;
        this.orientationLoc = (double)((this.lengthInSquares - this.orientationSquareCount) / 2) * this.squareWidth;
        this.renderFixedPatterns(marker);
        this.renderModeMessage(marker);
        this.renderDataLayers(marker);
        return this;
    }

    private void renderFixedPatterns(AztecCode marker) {
        this.orientationPattern(this.orientationLoc, this.orientationLoc, this.orientationSquareCount);
        this.locatorPattern(this.orientationLoc + 2.0 * this.squareWidth, this.orientationLoc + 2.0 * this.squareWidth, marker.getLocatorRingCount(), marker.locator);
        if (marker.structure == AztecCode.Structure.FULL) {
            int center = this.lengthInSquares / 2;
            int odd = (this.lengthInSquares - this.orientationSquareCount) / 2 % 2;
            int location = 0;
            while (center + location < this.lengthInSquares) {
                this.referenceGridLine(odd, center - location, 1, 0, this.lengthInSquares - odd);
                this.referenceGridLine(odd, center + location, 1, 0, this.lengthInSquares - odd);
                this.referenceGridLine(center - location, odd, 0, 1, this.lengthInSquares - odd);
                this.referenceGridLine(center + location, odd, 0, 1, this.lengthInSquares - odd);
                location += 16;
            }
        }
    }

    private void renderModeMessage(AztecCode marker) {
        this.codecMode.encodeMode(marker, this.bits);
        double s = this.squareWidth;
        double w = (double)this.orientationSquareCount * s;
        boolean hasGrid = marker.structure == AztecCode.Structure.FULL;
        int n = this.orientationSquareCount - 2 - (hasGrid ? 1 : 0);
        this.encodeBitsLine(0, n, this.orientationLoc + s, this.orientationLoc - s, 1, 0, hasGrid);
        this.encodeBitsLine(n, n, this.orientationLoc + w, this.orientationLoc + s, 0, 1, hasGrid);
        this.encodeBitsLine(n * 2, n, this.orientationLoc + w - 2.0 * s, this.orientationLoc + w, -1, 0, hasGrid);
        this.encodeBitsLine(n * 3, n, this.orientationLoc - s, this.orientationLoc + w - 2.0 * s, 0, -1, hasGrid);
    }

    private void renderDataLayers(AztecCode marker) {
        AztecGenerator.computeDataBitCoordinates(marker, this.messageCoordiantes);
        PackedBits8 bits = PackedBits8.wrap(marker.rawbits, marker.getCapacityBits());
        BoofMiscOps.checkTrue((Math.abs(this.messageCoordiantes.size() - bits.size) < marker.getWordBitCount() ? 1 : 0) != 0, (String)"Improperly constructed marker");
        FiducialRenderEngine render = Objects.requireNonNull(this.render);
        int coordinateIndex = bits.size - 1;
        for (int i = 0; i < bits.size; ++i) {
            if (bits.get(i) != 1) continue;
            this.messageCoordiantes.getCopy(coordinateIndex - i, this.coordinate);
            int x = this.coordinate.x + this.lengthInSquares / 2;
            int y = this.coordinate.y + this.lengthInSquares / 2;
            render.square((double)x * this.squareWidth, (double)y * this.squareWidth, this.squareWidth);
        }
    }

    void encodeBitsLine(int startBit, int count, double x0, double y0, int dx, int dy, boolean skipMiddle) {
        if (skipMiddle) {
            int middle = count / 2;
            this.encodeBitsLine(startBit, middle, x0, y0, dx, dy);
            int startBit2 = startBit + middle;
            this.encodeBitsLine(startBit2, count - middle, x0 += (double)(dx * (1 + middle)) * this.squareWidth, y0 += (double)(dy * (1 + middle)) * this.squareWidth, dx, dy);
        } else {
            this.encodeBitsLine(startBit, count, x0, y0, dx, dy);
        }
    }

    void encodeBitsLine(int startBit, int count, double x0, double y0, int dx, int dy) {
        FiducialRenderEngine render = Objects.requireNonNull(this.render);
        for (int bit = 0; bit < count; ++bit) {
            if (this.bits.get(startBit + bit) == 0) continue;
            render.square(x0 + (double)(dx * bit) * this.squareWidth, y0 + (double)(dy * bit) * this.squareWidth, this.squareWidth);
        }
    }

    protected void locatorPattern(double tl_x, double tl_y, int ringCount, AztecPyramid locator) {
        FiducialRenderEngine render = Objects.requireNonNull(this.render);
        locator.layers.reset();
        for (int ring = ringCount; ring > 0; --ring) {
            int squares = (ring - 1) * 4 + 1;
            double width = this.squareWidth * (double)squares;
            if (squares > 1) {
                render.square(tl_x, tl_y, width, this.squareWidth);
            } else {
                render.square(tl_x, tl_y, width);
            }
            Polygon2D_F64 where = ((AztecPyramid.Layer)locator.layers.grow()).square;
            where.get(0).setTo(tl_x, tl_y);
            where.get(1).setTo(tl_x + width, tl_y);
            where.get(2).setTo(tl_x + width, tl_y + width);
            where.get(3).setTo(tl_x, tl_y + width);
            tl_x += 2.0 * this.squareWidth;
            tl_y += 2.0 * this.squareWidth;
        }
        --locator.layers.size;
    }

    protected void orientationPattern(double tl_x, double tl_y, int moduleCount) {
        FiducialRenderEngine render = Objects.requireNonNull(this.render);
        double sw = this.squareWidth;
        double rw = (double)moduleCount * sw;
        render.square(tl_x, tl_y, rw, sw);
        render.square(tl_x - sw, tl_y, sw);
        render.rectangleWH(tl_x - sw, tl_y - sw, 2.0 * sw, sw);
        render.rectangleWH(tl_x + rw, tl_y - sw, sw, 2.0 * sw);
        render.square(tl_x + rw, tl_y + rw - sw, sw);
    }

    protected void referenceGridLine(int tl_x, int tl_y, int dx, int dy, int count) {
        FiducialRenderEngine render = Objects.requireNonNull(this.render);
        int forbidden0 = (this.lengthInSquares - this.orientationSquareCount) / 2 - 1;
        int forbidden1 = forbidden0 + this.orientationSquareCount + 2;
        for (int i = 0; i < count; i += 2) {
            int squareX = tl_x + i * dx;
            int squareY = tl_y + i * dy;
            if (squareX >= forbidden0 && squareX < forbidden1 && squareY >= forbidden0 && squareY < forbidden1) continue;
            double x = (double)squareX * this.squareWidth;
            double y = (double)squareY * this.squareWidth;
            render.square(x, y, this.squareWidth);
        }
    }

    public static void computeDataBitCoordinates(AztecCode marker, PackedArrayPoint2D_I16 coordinates) {
        coordinates.reset();
        int ringWidth = marker.getLocatorWidthSquares() + 6;
        int ringRadius = ringWidth / 2;
        boolean hasGrid = marker.structure == AztecCode.Structure.FULL;
        int row = -ringRadius - 2;
        int col = -ringRadius;
        int maxNum = ringWidth + 2 - (hasGrid ? 1 : 0);
        int cornerJump = 2;
        for (int layer = 1; layer <= marker.dataLayers; ++layer) {
            int traversed = AztecGenerator.dataBitCoordinatesLine(row, col, 0, 1, maxNum, hasGrid, coordinates);
            AztecGenerator.dataBitCoordinatesLine(row += cornerJump, col += traversed - 1, 1, 0, maxNum, hasGrid, coordinates);
            AztecGenerator.dataBitCoordinatesLine(row += traversed - 1, col -= cornerJump, 0, -1, maxNum, hasGrid, coordinates);
            AztecGenerator.dataBitCoordinatesLine(row -= cornerJump, col -= traversed - 1, -1, 0, maxNum, hasGrid, coordinates);
            maxNum += 4;
            if ((row -= traversed + 1) % 16 == 0 || (row + 1) % 16 == 0) {
                --row;
                cornerJump = 3;
                continue;
            }
            cornerJump = 2;
        }
    }

    static int dataBitCoordinatesLine(int row0, int col0, int drow, int dcol, int length, boolean hasGrid, PackedArrayPoint2D_I16 coordinates) {
        int leg = 1;
        if (hasGrid && ((row0 + dcol) % 16 == 0 || (col0 - drow) % 16 == 0)) {
            leg = 2;
        }
        coordinates.reserve(coordinates.size() + 2 * length);
        int traversed = 0;
        int written = 0;
        while (written < length) {
            int row = row0 + drow * traversed;
            int col = col0 + dcol * traversed;
            ++traversed;
            if (hasGrid && (row % 16 == 0 || col % 16 == 0)) continue;
            coordinates.append(col - drow * leg, row + dcol * leg);
            coordinates.append(col, row);
            ++written;
        }
        return traversed;
    }

    public AztecGenerator setMarkerWidth(double width) {
        this.markerWidth = width;
        return this;
    }

    public AztecGenerator setRender(FiducialRenderEngine render) {
        this.render = render;
        return this;
    }

    public double getMarkerWidth() {
        return this.markerWidth;
    }

    @Nullable
    public FiducialRenderEngine getRender() {
        return this.render;
    }
}

