/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.EciEncoding;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray_I8;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class QrCodeCodecBitsUtils
implements VerbosePrint {
    public static final String ALPHANUMERIC = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";
    public QrCode.Failure failureCause = QrCode.Failure.NONE;
    public final StringBuilder workString = new StringBuilder();
    public String selectedByteEncoding = "";
    @Nullable
    String forceEncoding;
    @Nullable
    String encodingEci;
    public String defaultEncoding = "ISO8859_1";
    static final CharsetEncoder asciiEncoder = Charset.forName("ISO-8859-1").newEncoder();
    @Nullable
    PrintStream verbose = null;

    public QrCodeCodecBitsUtils(@Nullable String forceEncoding, String defaultEncoding) {
        this.forceEncoding = forceEncoding;
        this.defaultEncoding = defaultEncoding;
    }

    public int decodeNumeric(PackedBits8 data, int bitLocation, int lengthBits) {
        int valB;
        int valA;
        int chunk;
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        while (length >= 3) {
            if (data.size < bitLocation + 10) {
                if (this.verbose != null) {
                    this.verbose.printf("overflow: numeric data.size=%d\n", data.size);
                }
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            chunk = data.read(bitLocation, 10, true);
            bitLocation += 10;
            valA = chunk / 100;
            valB = (chunk - valA * 100) / 10;
            int valC = chunk - valA * 100 - valB * 10;
            this.workString.append((char)(valA + 48));
            this.workString.append((char)(valB + 48));
            this.workString.append((char)(valC + 48));
            length -= 3;
        }
        if (length == 2) {
            if (data.size < bitLocation + 7) {
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            chunk = data.read(bitLocation, 7, true);
            bitLocation += 7;
            valA = chunk / 10;
            valB = chunk - valA * 10;
            this.workString.append((char)(valA + 48));
            this.workString.append((char)(valB + 48));
        } else if (length == 1) {
            if (data.size < bitLocation + 4) {
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int valA2 = data.read(bitLocation, 4, true);
            bitLocation += 4;
            this.workString.append((char)(valA2 + 48));
        }
        return bitLocation;
    }

    public int decodeAlphanumeric(PackedBits8 data, int bitLocation, int lengthBits) {
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        while (length >= 2) {
            if (data.size < bitLocation + 11) {
                if (this.verbose != null) {
                    this.verbose.printf("overflow: alphanumeric data.size=%d\n", data.size);
                }
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int chunk = data.read(bitLocation, 11, true);
            bitLocation += 11;
            int valA = chunk / 45;
            int valB = chunk - valA * 45;
            this.workString.append(QrCodeCodecBitsUtils.valueToAlphanumeric(valA));
            this.workString.append(QrCodeCodecBitsUtils.valueToAlphanumeric(valB));
            length -= 2;
        }
        if (length == 1) {
            if (data.size < bitLocation + 6) {
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int valA = data.read(bitLocation, 6, true);
            bitLocation += 6;
            this.workString.append(QrCodeCodecBitsUtils.valueToAlphanumeric(valA));
        }
        return bitLocation;
    }

    public int decodeByte(PackedBits8 data, int bitLocation, int lengthBits) {
        int i;
        int length = data.read(bitLocation, lengthBits, true);
        if (length * 8 > data.size - (bitLocation += lengthBits)) {
            if (this.verbose != null) {
                this.verbose.printf("overflow: byte data.size=%d\n", data.size);
            }
            this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
            return -1;
        }
        byte[] rawdata = new byte[length];
        for (i = 0; i < length; ++i) {
            rawdata[i] = (byte)data.read(bitLocation, 8, true);
            bitLocation += 8;
        }
        this.selectedByteEncoding = this.selectByteEncoding(rawdata);
        try {
            if (this.selectedByteEncoding.equalsIgnoreCase("binary")) {
                this.workString.ensureCapacity(this.workString.length() + rawdata.length);
                for (i = 0; i < rawdata.length; ++i) {
                    this.workString.append((char)(rawdata[i] & 0xFF));
                }
            } else {
                this.workString.append(new String(rawdata, this.selectedByteEncoding));
            }
        }
        catch (UnsupportedEncodingException ignored) {
            this.failureCause = QrCode.Failure.STRING_ENCODING_UNAVAILABLE;
            return -1;
        }
        return bitLocation;
    }

    private String selectByteEncoding(byte[] rawData) {
        if (this.encodingEci != null) {
            return this.encodingEci;
        }
        if (this.forceEncoding != null) {
            return this.forceEncoding;
        }
        if (EciEncoding.isValidUTF8(rawData)) {
            return "UTF8";
        }
        return this.defaultEncoding;
    }

    public int decodeKanji(PackedBits8 data, int bitLocation, int lengthBits) {
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        byte[] rawdata = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            if (data.size < bitLocation + 13) {
                if (this.verbose != null) {
                    this.verbose.printf("overflow: kanji data.size=%d\n", data.size);
                }
                this.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int letter = data.read(bitLocation, 13, true);
            bitLocation += 13;
            letter = (letter = letter / 192 << 8 | letter % 192) < 7936 ? (letter += 33088) : (letter += 49472);
            rawdata[i * 2] = (byte)(letter >> 8);
            rawdata[i * 2 + 1] = (byte)letter;
        }
        try {
            this.workString.append(new String(rawdata, "Shift_JIS"));
        }
        catch (UnsupportedEncodingException ignored) {
            this.failureCause = QrCode.Failure.KANJI_UNAVAILABLE;
            return -1;
        }
        return bitLocation;
    }

    public static boolean isKanji(char c) {
        return !asciiEncoder.canEncode(c);
    }

    public static boolean containsKanji(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (!QrCodeCodecBitsUtils.isKanji(message.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsByte(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (ALPHANUMERIC.indexOf(message.charAt(i)) != -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAlphaNumeric(String message) {
        for (int i = 0; i < message.length(); ++i) {
            int c = message.charAt(i) - 48;
            if (c >= 0 && c <= 9) continue;
            return true;
        }
        return false;
    }

    public static byte[] alphanumericToValues(String data) {
        byte[] output = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            int value = ALPHANUMERIC.indexOf(c);
            if (value < 0) {
                throw new IllegalArgumentException("Unsupported character '" + c + "' = " + c);
            }
            output[i] = (byte)value;
        }
        return output;
    }

    public static void flipBits8(byte[] array, int size) {
        for (int j = 0; j < size; ++j) {
            array[j] = QrCodeCodecBitsUtils.flipBits8(array[j] & 0xFF);
        }
    }

    public static void flipBits8(DogArray_I8 array) {
        QrCodeCodecBitsUtils.flipBits8(array.data, array.size);
    }

    public static byte flipBits8(int x) {
        int b = 0;
        for (int i = 0; i < 8; ++i) {
            b <<= 1;
            b |= x & 1;
            x >>= 1;
        }
        return (byte)b;
    }

    public static char valueToAlphanumeric(int value) {
        if (value < 0 || value >= ALPHANUMERIC.length()) {
            throw new RuntimeException("Alphanumeric: Value out of range. value=" + value);
        }
        return ALPHANUMERIC.charAt(value);
    }

    public static void encodeNumeric(byte[] numbers, int length, int lengthBits, PackedBits8 packed) {
        int value;
        packed.append(length, lengthBits, false);
        int index = 0;
        while (length - index >= 3) {
            value = numbers[index] * 100 + numbers[index + 1] * 10 + numbers[index + 2];
            packed.append(value, 10, false);
            index += 3;
        }
        if (length - index == 2) {
            value = numbers[index] * 10 + numbers[index + 1];
            packed.append(value, 7, false);
        } else if (length - index == 1) {
            value = numbers[index];
            packed.append(value, 4, false);
        }
    }

    public static void encodeAlphanumeric(byte[] numbers, int length, int lengthBits, PackedBits8 packed) {
        int value;
        packed.append(length, lengthBits, false);
        int index = 0;
        while (length - index >= 2) {
            value = numbers[index] * 45 + numbers[index + 1];
            packed.append(value, 11, false);
            index += 2;
        }
        if (length - index == 1) {
            value = numbers[index];
            packed.append(value, 6, false);
        }
    }

    public static void encodeBytes(byte[] data, int length, int lengthBits, PackedBits8 packed) {
        packed.append(length, lengthBits, false);
        for (int i = 0; i < length; ++i) {
            packed.append(data[i] & 0xFF, 8, false);
        }
    }

    public static void encodeKanji(byte[] bytes, int length, int lengthBits, PackedBits8 packed) {
        packed.append(length, lengthBits, false);
        for (int i = 0; i < length * 2; i += 2) {
            int adjusted;
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            if (code >= 33088 && code <= 40956) {
                adjusted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                adjusted = code - 49472;
            } else {
                throw new IllegalArgumentException("Invalid byte sequence. At " + i / 2);
            }
            int encoded = (adjusted >> 8) * 192 + (adjusted & 0xFF);
            packed.append(encoded, 13, false);
        }
    }

    public static MessageSegment createSegmentNumeric(String message) {
        byte[] numbers = new byte[message.length()];
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            int values = c - 48;
            if (values < 0 || values > 9) {
                throw new RuntimeException("Expected each character to be a number from 0 to 9, not '" + c + "'");
            }
            numbers[i] = (byte)values;
        }
        return QrCodeCodecBitsUtils.createSegmentNumeric(numbers);
    }

    public static MessageSegment createSegmentNumeric(byte[] numbers) {
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] >= 0 && numbers[i] <= 9) continue;
            throw new IllegalArgumentException("All numbers must have a value from 0 to 9");
        }
        StringBuilder builder = new StringBuilder(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            builder.append(Integer.toString(numbers[i]));
        }
        MessageSegment segment = new MessageSegment();
        segment.message = builder.toString();
        segment.data = numbers;
        segment.length = numbers.length;
        segment.mode = QrCode.Mode.NUMERIC;
        segment.encodedSizeBits += 10 * (segment.length / 3);
        if (segment.length % 3 == 2) {
            segment.encodedSizeBits += 7;
        } else if (segment.length % 3 == 1) {
            segment.encodedSizeBits += 4;
        }
        return segment;
    }

    public static MessageSegment createSegmentAlphanumeric(String alphaNumeric) {
        byte[] values = QrCodeCodecBitsUtils.alphanumericToValues(alphaNumeric);
        MessageSegment segment = new MessageSegment();
        segment.message = alphaNumeric;
        segment.data = values;
        segment.length = values.length;
        segment.mode = QrCode.Mode.ALPHANUMERIC;
        segment.encodedSizeBits += 11 * (segment.length / 2);
        if (segment.length % 2 == 1) {
            segment.encodedSizeBits += 6;
        }
        return segment;
    }

    public static MessageSegment createSegmentBytes(byte[] data) {
        StringBuilder builder = new StringBuilder(data.length);
        for (int i = 0; i < data.length; ++i) {
            builder.append((char)data[i]);
        }
        MessageSegment segment = new MessageSegment();
        segment.message = builder.toString();
        segment.data = data;
        segment.length = data.length;
        segment.mode = QrCode.Mode.BYTE;
        segment.encodedSizeBits += 8 * segment.length;
        return segment;
    }

    public static MessageSegment createSegmentKanji(String message) {
        byte[] bytes;
        try {
            bytes = message.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
        MessageSegment segment = new MessageSegment();
        segment.message = message;
        segment.data = bytes;
        segment.length = message.length();
        segment.mode = QrCode.Mode.KANJI;
        segment.encodedSizeBits += 13 * segment.length;
        return segment;
    }

    public static void addAutomatic(Charset byteCharacterSet, String message, List<MessageSegment> segments) {
        if (QrCodeCodecBitsUtils.containsKanji(message)) {
            int start = 0;
            boolean kanji = QrCodeCodecBitsUtils.isKanji(message.charAt(0));
            for (int i = 0; i < message.length(); ++i) {
                if (QrCodeCodecBitsUtils.isKanji(message.charAt(i))) {
                    if (kanji) continue;
                    QrCodeCodecBitsUtils.addAutomatic(byteCharacterSet, message.substring(start, i), segments);
                    start = i;
                    kanji = true;
                    continue;
                }
                if (!kanji) continue;
                segments.add(QrCodeCodecBitsUtils.createSegmentKanji(message.substring(start, i)));
                start = i;
                kanji = false;
            }
            if (kanji) {
                segments.add(QrCodeCodecBitsUtils.createSegmentKanji(message.substring(start)));
            } else {
                QrCodeCodecBitsUtils.addAutomatic(byteCharacterSet, message.substring(start), segments);
            }
        } else if (QrCodeCodecBitsUtils.containsByte(message)) {
            segments.add(QrCodeCodecBitsUtils.createSegmentBytes(message.getBytes(byteCharacterSet)));
        } else if (QrCodeCodecBitsUtils.containsAlphaNumeric(message)) {
            segments.add(QrCodeCodecBitsUtils.createSegmentAlphanumeric(message));
        } else {
            segments.add(QrCodeCodecBitsUtils.createSegmentNumeric(message));
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public static class MessageSegment {
        public QrCode.Mode mode;
        public String message;
        public byte[] data;
        public int length;
        public int encodedSizeBits;
    }
}

