/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrCodeCodecBitsUtils;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.ReedSolomonCodes_U8;
import georegression.struct.point.Point2D_I32;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray_I8;
import org.ejml.data.BMatrixRMaj;
import org.ejml.ops.CommonOps_BDRM;
import org.jetbrains.annotations.Nullable;

public class QrCodeEncoder {
    private final ReedSolomonCodes_U8 rscodes = new ReedSolomonCodes_U8(8, 285, 0);
    private final QrCode qr = new QrCode();
    private boolean autoErrorCorrection;
    private boolean autoMask;
    private Charset byteCharacterSet = StandardCharsets.UTF_8;
    PackedBits8 packed = new PackedBits8();
    private final DogArray_I8 message = new DogArray_I8();
    private final DogArray_I8 ecc = new DogArray_I8();
    private final List<QrCodeCodecBitsUtils.MessageSegment> segments = new ArrayList<QrCodeCodecBitsUtils.MessageSegment>();

    public QrCodeEncoder() {
        this.reset();
    }

    public void reset() {
        this.qr.reset();
        this.qr.version = -1;
        this.packed.size = 0;
        this.autoMask = true;
        this.autoErrorCorrection = true;
        this.segments.clear();
    }

    public QrCodeEncoder setVersion(int version) {
        this.qr.version = version;
        return this;
    }

    public QrCodeEncoder setError(@Nullable QrCode.ErrorLevel level) {
        boolean bl = this.autoErrorCorrection = level == null;
        if (level != null) {
            this.qr.error = level;
        }
        return this;
    }

    public QrCodeEncoder setMask(QrCodeMaskPattern pattern) {
        this.autoMask = false;
        this.qr.mask = pattern;
        return this;
    }

    public QrCodeEncoder addAutomatic(String message) {
        QrCodeCodecBitsUtils.addAutomatic(this.byteCharacterSet, message, this.segments);
        return this;
    }

    public QrCodeEncoder addNumeric(String message) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentNumeric(message));
        return this;
    }

    public QrCodeEncoder addNumeric(byte[] numbers) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentNumeric(numbers));
        return this;
    }

    private void encodeNumeric(byte[] numbers, int length) {
        this.qr.mode = QrCode.Mode.NUMERIC;
        this.packed.append(1, 4, false);
        int lengthBits = QrCodeEncoder.getLengthBitsNumeric(this.qr.version);
        QrCodeCodecBitsUtils.encodeNumeric(numbers, length, lengthBits, this.packed);
    }

    public QrCodeEncoder addAlphanumeric(String alphaNumeric) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentAlphanumeric(alphaNumeric));
        return this;
    }

    private void encodeAlphanumeric(byte[] numbers, int length) {
        this.qr.mode = QrCode.Mode.ALPHANUMERIC;
        this.packed.append(2, 4, false);
        int lengthBits = QrCodeEncoder.getLengthBitsAlphanumeric(this.qr.version);
        QrCodeCodecBitsUtils.encodeAlphanumeric(numbers, length, lengthBits, this.packed);
    }

    public QrCodeEncoder addBytes(String message) {
        return this.addBytes(message.getBytes(this.byteCharacterSet));
    }

    public QrCodeEncoder addBytes(byte[] data) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentBytes(data));
        return this;
    }

    private void encodeBytes(byte[] data, int length) {
        this.qr.mode = QrCode.Mode.BYTE;
        this.packed.append(4, 4, false);
        int lengthBits = QrCodeEncoder.getLengthBitsBytes(this.qr.version);
        QrCodeCodecBitsUtils.encodeBytes(data, length, lengthBits, this.packed);
    }

    public QrCodeEncoder addKanji(String message) {
        this.segments.add(QrCodeCodecBitsUtils.createSegmentKanji(message));
        return this;
    }

    private void encodeKanji(byte[] bytes, int length) {
        this.qr.mode = QrCode.Mode.KANJI;
        this.packed.append(8, 4, false);
        int lengthBits = QrCodeEncoder.getLengthBitsKanji(this.qr.version);
        QrCodeCodecBitsUtils.encodeKanji(bytes, length, lengthBits, this.packed);
    }

    public static int getLengthBitsNumeric(int version) {
        return QrCodeEncoder.getLengthBits(version, 10, 12, 14);
    }

    public static int getLengthBitsAlphanumeric(int version) {
        return QrCodeEncoder.getLengthBits(version, 9, 11, 13);
    }

    public static int getLengthBitsBytes(int version) {
        return QrCodeEncoder.getLengthBits(version, 8, 16, 16);
    }

    public static int getLengthBitsKanji(int version) {
        return QrCodeEncoder.getLengthBits(version, 8, 10, 12);
    }

    private static int getLengthBits(int version, int bitsA, int bitsB, int bitsC) {
        int lengthBits = version < 10 ? bitsA : (version < 27 ? bitsB : bitsC);
        return lengthBits;
    }

    public QrCode fixate() {
        this.autoSelectVersionAndError();
        int expectedBitSize = this.bitsAtVersion(this.qr.version);
        this.qr.message = "";
        block6: for (int segIdx = 0; segIdx < this.segments.size(); ++segIdx) {
            QrCodeCodecBitsUtils.MessageSegment m = this.segments.get(segIdx);
            this.qr.message = this.qr.message + m.message;
            switch (m.mode) {
                case NUMERIC: {
                    this.encodeNumeric(m.data, m.length);
                    continue block6;
                }
                case ALPHANUMERIC: {
                    this.encodeAlphanumeric(m.data, m.length);
                    continue block6;
                }
                case BYTE: {
                    this.encodeBytes(m.data, m.length);
                    continue block6;
                }
                case KANJI: {
                    this.encodeKanji(m.data, m.length);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unknown");
                }
            }
        }
        if (this.packed.size != expectedBitSize) {
            throw new RuntimeException("Bad size code. " + this.packed.size + " vs " + expectedBitSize);
        }
        int maxBits = QrCode.VERSION_INFO[this.qr.version].codewords * 8;
        if (this.packed.size > maxBits) {
            throw new IllegalArgumentException("The message is longer than the max possible size");
        }
        if (this.packed.size + 4 <= maxBits) {
            this.packed.append(0, 4, false);
        }
        this.bitsToMessage(this.packed);
        if (this.autoMask) {
            this.qr.mask = QrCodeEncoder.selectMask(this.qr);
        }
        return this.qr;
    }

    static QrCodeMaskPattern selectMask(QrCode qr) {
        int N = qr.getNumberOfModules();
        int totalBytes = QrCode.VERSION_INFO[qr.version].codewords;
        List<Point2D_I32> locations = QrCode.LOCATION_BITS[qr.version];
        QrCodeMaskPattern bestMask = null;
        double bestScore = Double.MAX_VALUE;
        PackedBits8 bits = new PackedBits8();
        bits.size = totalBytes * 8;
        bits.data = qr.rawbits;
        if (bits.size > locations.size()) {
            throw new RuntimeException("BUG in code");
        }
        QrCodeCodeWordLocations matrix = QrCodeCodeWordLocations.qrcode(qr.version);
        for (QrCodeMaskPattern mask : QrCodeMaskPattern.values()) {
            double score = QrCodeEncoder.scoreMask(N, locations, bits, matrix, mask);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestMask = mask;
        }
        return Objects.requireNonNull(bestMask);
    }

    private static double scoreMask(int N, List<Point2D_I32> locations, PackedBits8 bits, QrCodeCodeWordLocations matrix, QrCodeMaskPattern mask) {
        FoundFeatures features = new FoundFeatures();
        int blackInBlock = 0;
        for (int i = 0; i < bits.size; ++i) {
            Point2D_I32 p = locations.get(i);
            boolean v = mask.apply(p.y, p.x, bits.get(i)) == 1;
            matrix.unsafe_set(p.y, p.x, v);
            if (v) {
                ++blackInBlock;
            }
            if ((i + 1) % 8 != 0) continue;
            if (blackInBlock == 0 || blackInBlock == 8) {
                ++features.sameColorBlock;
            }
            blackInBlock = 0;
        }
        QrCodeEncoder.detectAdjacentAndPositionPatterns(N, matrix, features);
        double scale = (double)matrix.sum() / (double)(N * N);
        scale = scale < 0.5 ? 0.5 - scale : scale - 0.5;
        return (double)(features.adjacent + 3 * features.sameColorBlock + 40 * features.position) + (double)(N * N) * scale;
    }

    static void detectAdjacentAndPositionPatterns(int N, QrCodeCodeWordLocations matrix, FoundFeatures features) {
        for (int foo = 0; foo < 2; ++foo) {
            for (int row = 0; row < N; ++row) {
                int index = row * N;
                int col = 1;
                while (col < N) {
                    if (matrix.data[index] == matrix.data[index + 1]) {
                        ++features.adjacent;
                    }
                    ++col;
                    ++index;
                }
                index = row * N;
                col = 6;
                while (col < N) {
                    if (matrix.data[index] && !matrix.data[index + 1] && matrix.data[index + 2] && matrix.data[index + 3] && matrix.data[index + 4] && !matrix.data[index + 5] && matrix.data[index + 6]) {
                        ++features.position;
                    }
                    ++col;
                    ++index;
                }
            }
            CommonOps_BDRM.transposeSquare((BMatrixRMaj)matrix);
        }
        features.adjacent -= 216 + (N - 18) * 2;
    }

    private void autoSelectVersionAndError() {
        QrCode.VersionInfo v;
        int dataBits;
        int totalBytes;
        if (this.qr.version == -1) {
            QrCode.ErrorLevel[] levelsToTry = this.autoErrorCorrection ? new QrCode.ErrorLevel[]{QrCode.ErrorLevel.M, QrCode.ErrorLevel.L} : new QrCode.ErrorLevel[]{this.qr.error};
            QrCode.ErrorLevel[] errorLevelArray = levelsToTry;
            int n = errorLevelArray.length;
            block0: for (int i = 0; i < n; ++i) {
                QrCode.ErrorLevel error;
                this.qr.error = error = errorLevelArray[i];
                for (int i2 = 1; i2 <= 40; ++i2) {
                    int dataBits2 = this.bitsAtVersion(i2);
                    int totalBytes2 = QrCodeEncoder.bitsToBytes(dataBits2);
                    if (totalBytes2 > QrCode.VERSION_INFO[i2].totalDataBytes(this.qr.error)) continue;
                    this.qr.version = i2;
                    break block0;
                }
            }
            if (this.qr.version == -1) {
                throw new IllegalArgumentException("Packet too to be encoded in a qr code");
            }
        } else if (this.autoErrorCorrection) {
            @Nullable QrCode.ErrorLevel error = null;
            QrCode.VersionInfo v2 = QrCode.VERSION_INFO[this.qr.version];
            int dataBits3 = this.bitsAtVersion(this.qr.version);
            int totalBytes3 = QrCodeEncoder.bitsToBytes(dataBits3);
            for (QrCode.ErrorLevel level : QrCode.ErrorLevel.values()) {
                if (totalBytes3 > v2.totalDataBytes(level)) continue;
                error = level;
            }
            if (error == null) {
                throw new IllegalArgumentException("You need to use a high version number to store the data. Tried all error correction levels at version " + this.qr.version + ". Total Data " + this.packed.size / 8);
            }
            this.qr.error = error;
        }
        if ((totalBytes = QrCodeEncoder.bitsToBytes(dataBits = this.bitsAtVersion(this.qr.version))) > (v = QrCode.VERSION_INFO[this.qr.version]).totalDataBytes(this.qr.error)) {
            int encodedBits = this.totalEncodedBitsNoOverHead();
            throw new IllegalArgumentException("Version and error level can't encode all the data. Version = " + this.qr.version + " , Error = " + this.qr.error + " , Encoded Bits = " + encodedBits + " , Overhead Bits = " + (dataBits - encodedBits) + " , Data Bytes = " + totalBytes + " , Limit Bytes = " + v.totalDataBytes(this.qr.error));
        }
    }

    private static int bitsToBytes(int totalBits) {
        return totalBits / 8 + (totalBits % 8 > 0 ? 1 : 0);
    }

    private int bitsAtVersion(int version) {
        int total = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            total += this.sizeInBits(this.segments.get(i), version);
        }
        return total;
    }

    private int totalEncodedBitsNoOverHead() {
        int total = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            total += this.segments.get((int)i).encodedSizeBits;
        }
        return total;
    }

    protected void bitsToMessage(PackedBits8 stream) {
        stream.append(0, (8 - stream.size % 8) % 8, false);
        QrCode.VersionInfo info = QrCode.VERSION_INFO[this.qr.version];
        QrCode.BlockInfo block = Objects.requireNonNull(info.levels.get((Object)this.qr.error));
        this.qr.rawbits = new byte[info.codewords];
        int wordsBlockAllA = block.codewords;
        int wordsBlockDataA = block.dataCodewords;
        int wordsEcc = wordsBlockAllA - wordsBlockDataA;
        int numBlocksA = block.blocks;
        int wordsBlockAllB = wordsBlockAllA + 1;
        int wordsBlockDataB = wordsBlockDataA + 1;
        int numBlocksB = (info.codewords - wordsBlockAllA * numBlocksA) / wordsBlockAllB;
        this.message.resize(wordsBlockDataA + 1);
        int startEcc = numBlocksA * wordsBlockDataA + numBlocksB * wordsBlockDataB;
        int totalBlocks = numBlocksA + numBlocksB;
        this.rscodes.generator(wordsEcc);
        this.ecc.resize(wordsEcc);
        this.encodeBlocks(stream, wordsBlockDataA, numBlocksA, 0, 0, startEcc, totalBlocks);
        this.encodeBlocks(stream, wordsBlockDataB, numBlocksB, wordsBlockDataA * numBlocksA, numBlocksA, startEcc, totalBlocks);
    }

    private void encodeBlocks(PackedBits8 stream, int bytesInDataBlock, int numberOfBlocks, int streamOffset, int blockOffset, int startEcc, int stride) {
        this.message.size = bytesInDataBlock;
        for (int idxBlock = 0; idxBlock < numberOfBlocks; ++idxBlock) {
            int length = Math.min(bytesInDataBlock, Math.max(0, stream.arrayLength() - streamOffset));
            if (length > 0) {
                System.arraycopy(stream.data, streamOffset, this.message.data, 0, length);
            }
            this.addPadding(this.message, length, 55, 136);
            QrCodeCodecBitsUtils.flipBits8(this.message);
            this.rscodes.computeECC(this.message, this.ecc);
            QrCodeCodecBitsUtils.flipBits8(this.message);
            QrCodeCodecBitsUtils.flipBits8(this.ecc);
            this.copyIntoRawData(this.message, this.ecc, idxBlock + blockOffset, stride, startEcc, this.qr.rawbits);
            streamOffset += this.message.size;
        }
    }

    private void addPadding(DogArray_I8 queue, int dataBytes, int padding0, int padding1) {
        boolean a = true;
        for (int i = dataBytes; i < queue.size; ++i) {
            queue.data[i] = a ? (byte)padding0 : (byte)padding1;
            a = !a;
        }
    }

    private void copyIntoRawData(DogArray_I8 message, DogArray_I8 ecc, int offset, int stride, int startEcc, byte[] output) {
        int i;
        for (i = 0; i < message.size; ++i) {
            output[i * stride + offset] = message.data[i];
        }
        for (i = 0; i < ecc.size; ++i) {
            output[i * stride + offset + startEcc] = ecc.data[i];
        }
    }

    public Charset getByteCharacterSet() {
        return this.byteCharacterSet;
    }

    public void setByteCharacterSet(Charset byteCharacterSet) {
        this.byteCharacterSet = byteCharacterSet;
    }

    public int sizeInBits(QrCodeCodecBitsUtils.MessageSegment segment, int version) {
        int n;
        switch (segment.mode) {
            case NUMERIC: {
                n = QrCodeEncoder.getLengthBitsNumeric(version);
                break;
            }
            case ALPHANUMERIC: {
                n = QrCodeEncoder.getLengthBitsAlphanumeric(version);
                break;
            }
            case BYTE: {
                n = QrCodeEncoder.getLengthBitsBytes(version);
                break;
            }
            case KANJI: {
                n = QrCodeEncoder.getLengthBitsKanji(version);
                break;
            }
            default: {
                throw new RuntimeException("Egads");
            }
        }
        int lengthBits = n;
        return segment.encodedSizeBits + lengthBits + 4;
    }

    static class FoundFeatures {
        int adjacent = 0;
        int sameColorBlock = 0;
        int position = 0;

        FoundFeatures() {
        }
    }
}

