/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.drawing.FiducialRenderEngine;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;

public abstract class QrGeneratorBase<T extends QrGeneratorBase<T>> {
    public double markerWidth = 1.0;
    protected boolean renderData = true;
    protected double moduleWidth;
    protected int numModules;
    protected List<Point2D_I32> bitLocations;
    protected FiducialRenderEngine render;

    protected QrGeneratorBase(double markerWidth) {
        this.markerWidth = markerWidth;
    }

    protected QrGeneratorBase() {
    }

    protected void positionPattern(double x, double y, Polygon2D_F64 where) {
        this.render.square(x, y, this.moduleWidth * 7.0, this.moduleWidth);
        this.render.square(x + this.moduleWidth * 2.0, y + this.moduleWidth * 2.0, this.moduleWidth * 3.0);
        where.get(0).setTo(x, y);
        where.get(1).setTo(x + this.moduleWidth * 7.0, y);
        where.get(2).setTo(x + this.moduleWidth * 7.0, y + this.moduleWidth * 7.0);
        where.get(3).setTo(x, y + this.moduleWidth * 7.0);
    }

    protected void timingPattern(double x, double y, double slopeX, double slopeY, int length) {
        for (int i = 1; i < length; i += 2) {
            this.render.square(x + (double)i * slopeX, y + (double)i * slopeY, this.moduleWidth);
        }
    }

    protected void square(int row, int col) {
        this.render.square((double)col * this.moduleWidth, (double)row * this.moduleWidth, this.moduleWidth);
    }

    public T setMarkerWidth(double value) {
        this.markerWidth = value;
        return (T)this;
    }

    public T setRender(FiducialRenderEngine render) {
        this.render = render;
        return (T)this;
    }

    public double getMarkerWidth() {
        return this.markerWidth;
    }

    public FiducialRenderEngine getRender() {
        return this.render;
    }
}

