/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.interpolate.InterpolatePixelDistortS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.MovingAverage;
import boofcv.struct.ConfigLength;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public abstract class SquareLocatorPatternDetectorBase<T extends ImageGray<T>>
implements VerbosePrint {
    protected InterpolatePixelS<T> interpolate;
    protected double maxContourFraction = 1.3333333333333333;
    protected DetectPolygonBinaryGrayRefine<T> squareDetector;
    protected MovingAverage profilingMS = new MovingAverage(0.8);
    @Nullable
    protected PrintStream verbose = null;

    protected SquareLocatorPatternDetectorBase(DetectPolygonBinaryGrayRefine<T> squareDetector) {
        this.squareDetector = squareDetector;
        squareDetector.getDetector().setConvex(true);
        squareDetector.getDetector().setOutputClockwiseUpY(false);
        squareDetector.getDetector().setNumberOfSides(4, 4);
        this.interpolate = FactoryInterpolation.bilinearPixelS((Class)squareDetector.getInputType(), (BorderType)BorderType.EXTENDED);
    }

    public void process(T gray, GrayU8 binary) {
        this.configureContourDetector(gray);
        this.interpolate.setImage(gray);
        this.squareDetector.process(gray, binary);
        long time0 = System.nanoTime();
        this.findLocatorPatternsFromSquares();
        long time1 = System.nanoTime();
        this.profilingMS.update((double)(time1 - time0) * 1.0E-6);
    }

    protected abstract void findLocatorPatternsFromSquares();

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.interpolate = FactoryInterpolation.bilinearPixelS((Class)this.squareDetector.getInputType(), (BorderType)BorderType.EXTENDED);
        if (model != null) {
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(model.undistort_F32(true, true));
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(model.distort_F32(true, true));
            this.squareDetector.setLensDistortion(width, height, (PixelTransform)distToUndist, (PixelTransform)undistToDist);
            Point2Transform2_F32 u2d = model.distort_F32(true, true);
            this.interpolate = new InterpolatePixelDistortS(this.interpolate, u2d);
        } else {
            this.squareDetector.setLensDistortion(width, height, null, null);
        }
    }

    protected void configureContourDetector(T gray) {
        int maxContourSize = (int)((double)Math.min(((ImageGray)gray).width, ((ImageGray)gray).height) * this.maxContourFraction);
        BinaryContourFinder contourFinder = this.squareDetector.getDetector().getContourFinder();
        contourFinder.setMaxContour(ConfigLength.fixed((double)maxContourSize));
        contourFinder.setSaveInnerContour(false);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public InterpolatePixelS<T> getInterpolate() {
        return this.interpolate;
    }

    public double getMaxContourFraction() {
        return this.maxContourFraction;
    }

    public void setMaxContourFraction(double maxContourFraction) {
        this.maxContourFraction = maxContourFraction;
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.squareDetector;
    }

    public MovingAverage getProfilingMS() {
        return this.profilingMS;
    }
}

