/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.nister2006;

import boofcv.alg.scene.bow.BowDistanceTypes;
import boofcv.alg.scene.bow.BowMatch;
import boofcv.alg.scene.bow.BowUtils;
import boofcv.alg.scene.bow.InvertedFile;
import boofcv.alg.scene.nister2006.TupleMapDistanceNorm;
import boofcv.alg.scene.vocabtree.HierarchicalVocabularyTree;
import boofcv.misc.BoofLambdas;
import boofcv.struct.ConfigLength;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.BigDogGrowth;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class RecognitionVocabularyTreeNister2006<Point>
implements VerbosePrint {
    public HierarchicalVocabularyTree<Point> tree;
    public int minimumDepthFromRoot = 0;
    public ConfigLength maximumQueryImagesInNode = ConfigLength.relative((double)1.0, (double)1.0);
    public final GrowArray<InvertedFile> invertedFiles = new GrowArray(InvertedFile::new, InvertedFile::reset);
    protected final BigDogArray_I32 imagesDB = new BigDogArray_I32(100, 10000, BigDogGrowth.GROW_FIRST);
    protected final DogArray<BowMatch> matches = new DogArray(BowMatch::new, BowMatch::reset);
    protected TupleMapDistanceNorm distanceFunction = new TupleMapDistanceNorm.L2();
    protected final DogArray_I32 featureIdxToLeafID = new DogArray_I32();
    protected final DogArray<Frequency> frequencies = new DogArray(Frequency::new, Frequency::reset);
    DogArray_I32 imageIdx_to_match = new DogArray_I32();
    DogArray_I32 nodeIdx_to_match = new DogArray_I32();
    DogArray_F32 tmpDescWeights = new DogArray_F32();
    DogArray_I32 tmpDescWords = new DogArray_I32();
    @Nullable
    PrintStream verbose;

    public void initializeTree(HierarchicalVocabularyTree<Point> tree) {
        this.tree = tree;
        this.clearImages();
    }

    public void clearImages() {
        this.imagesDB.reset();
        this.invertedFiles.reset();
        if (this.tree != null) {
            this.invertedFiles.resize(this.tree.nodes.size);
        }
    }

    public void addImage(int imageID, List<Point> imageFeatures) {
        if (imageFeatures.isEmpty()) {
            return;
        }
        int imageIdx = this.imagesDB.size;
        this.imagesDB.append(imageID);
        this.describe(imageFeatures, this.tmpDescWeights, this.tmpDescWords);
        for (int wordIdx = 0; wordIdx < this.tmpDescWords.size; ++wordIdx) {
            int word = this.tmpDescWords.get(wordIdx);
            ((InvertedFile)((Object)this.invertedFiles.get(word))).addImage(imageIdx, this.tmpDescWeights.get(wordIdx));
        }
    }

    public boolean query(List<Point> queryImage, @Nullable BoofLambdas.FilterInt filter, int limit) {
        this.matches.reset();
        if (queryImage.isEmpty()) {
            return false;
        }
        this.findAndScoreMatches(queryImage);
        if (this.matches.isEmpty()) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("raw matches.size=" + this.matches.size);
        }
        for (int i = 0; i < this.matches.size(); ++i) {
            BowMatch m = (BowMatch)this.matches.get(i);
            this.imageIdx_to_match.set(m.identification, -1);
            m.identification = this.imagesDB.get(m.identification);
        }
        BowUtils.filterAndSortMatches(this.matches, filter, limit);
        return this.matches.size > 0;
    }

    protected void findAndScoreMatches(List<Point> queryImage) {
        int maximumInvertedFileLength = this.maximumQueryImagesInNode.computeI((double)this.imagesDB.size);
        this.describe(queryImage, this.tmpDescWeights, this.tmpDescWords);
        this.imageIdx_to_match.resize(this.imagesDB.size, -1);
        for (int wordIdx = 0; wordIdx < this.tmpDescWords.size; ++wordIdx) {
            float queryWordWeight = this.tmpDescWeights.get(wordIdx);
            HierarchicalVocabularyTree.Node node = (HierarchicalVocabularyTree.Node)this.tree.nodes.get(this.tmpDescWords.get(wordIdx));
            InvertedFile invertedFile = (InvertedFile)((Object)this.invertedFiles.get(node.index));
            if (invertedFile.size > maximumInvertedFileLength) continue;
            for (int i = 0; i < invertedFile.size; ++i) {
                BowMatch m;
                int imageIdx = invertedFile.get(i);
                if (this.imageIdx_to_match.get(imageIdx) == -1) {
                    this.imageIdx_to_match.set(imageIdx, this.matches.size);
                    m = (BowMatch)this.matches.grow();
                    m.identification = imageIdx;
                } else {
                    m = (BowMatch)this.matches.get(this.imageIdx_to_match.get(imageIdx));
                }
                m.error += this.distanceFunction.distanceUpdate(queryWordWeight, invertedFile.weights.get(i));
            }
        }
    }

    protected void describe(List<Point> imageFeatures, DogArray_F32 descWeights, DogArray_I32 descWords) {
        this.frequencies.reset();
        descWeights.reset();
        descWords.reset();
        this.nodeIdx_to_match.resize(this.tree.nodes.size, -1);
        this.featureIdxToLeafID.resize(imageFeatures.size());
        for (int featureIdx = 0; featureIdx < imageFeatures.size(); ++featureIdx) {
            int leafID;
            this.featureIdxToLeafID.data[featureIdx] = leafID = this.tree.searchPathToLeaf(imageFeatures.get(featureIdx), (BoofLambdas.ProcessIndex<HierarchicalVocabularyTree.Node>)((BoofLambdas.ProcessIndex)(depth, node) -> {
                Frequency f;
                if (depth < this.minimumDepthFromRoot || node.weight <= 0.0) {
                    return;
                }
                int frequencyIdx = this.nodeIdx_to_match.get(node.index);
                if (frequencyIdx == -1) {
                    this.nodeIdx_to_match.set(node.index, this.frequencies.size);
                    f = (Frequency)this.frequencies.grow();
                    f.node = node;
                } else {
                    f = (Frequency)this.frequencies.get(frequencyIdx);
                }
                ++f.totalAppearances;
            }));
        }
        for (int i = 0; i < this.frequencies.size; ++i) {
            this.nodeIdx_to_match.set(((Frequency)this.frequencies.get((int)i)).node.index, -1);
        }
        if (this.frequencies.isEmpty()) {
            return;
        }
        double totalUniqueWordsSeenByImage = this.frequencies.size;
        descWeights.reserve(this.frequencies.size);
        descWords.reserve(this.frequencies.size);
        for (int i = 0; i < this.frequencies.size; ++i) {
            Frequency f = (Frequency)this.frequencies.get(i);
            double termFrequency = (double)f.totalAppearances / totalUniqueWordsSeenByImage;
            descWeights.add((float)(termFrequency * f.node.weight));
            descWords.add(f.node.index);
        }
        this.distanceFunction.normalize(descWeights);
    }

    public void setDistanceType(BowDistanceTypes type) {
        TupleMapDistanceNorm tupleMapDistanceNorm;
        switch (type) {
            case L1: {
                tupleMapDistanceNorm = new TupleMapDistanceNorm.L1();
                break;
            }
            case L2: {
                tupleMapDistanceNorm = new TupleMapDistanceNorm.L2();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
        this.distanceFunction = tupleMapDistanceNorm;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> settings) {
        this.verbose = out;
    }

    public HierarchicalVocabularyTree<Point> getTree() {
        return this.tree;
    }

    public BigDogArray_I32 getImagesDB() {
        return this.imagesDB;
    }

    public DogArray<BowMatch> getMatches() {
        return this.matches;
    }

    public TupleMapDistanceNorm getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(TupleMapDistanceNorm distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public DogArray_I32 getFeatureIdxToLeafID() {
        return this.featureIdxToLeafID;
    }

    protected static class Frequency {
        int totalAppearances;
        HierarchicalVocabularyTree.Node node;

        protected Frequency() {
        }

        public void reset() {
            this.totalAppearances = 0;
            this.node = null;
        }
    }
}

