/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.factory.fiducial.ConfigLlah;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.shape.ConfigEllipseEdgeCheck;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;

public class ConfigUchiyaMarker
implements Configuration {
    public double markerWidth = -1.0;
    public double markerHeight = -1.0;
    public ConfigThreshold threshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (ConfigLength)ConfigLength.fixed((double)20.0));
    public ConfigLlah llah = new ConfigLlah();
    public ConfigRansac ransac = new ConfigRansac(200, 2.0);
    public ConnectRule contourRule = ConnectRule.EIGHT;
    public ConfigLength contourMinimumLength = ConfigLength.fixed((double)5.0);
    public ConfigLength contourMaximumLength = ConfigLength.relative((double)0.25, (double)10.0);
    public double maxDistanceFromEllipse = 3.0;
    public final ConfigLength minimumMinorAxis = ConfigLength.fixed((double)0.5);
    public double maxMajorToMinorRatio = 5.0;
    public ConfigEllipseEdgeCheck checkEdge = new ConfigEllipseEdgeCheck();

    public ConfigUchiyaMarker() {
        this.llah.numberOfNeighborsN = 7;
        this.llah.sizeOfCombinationM = 5;
        this.llah.quantizationK = 32;
        this.llah.hashType = ConfigLlah.HashType.AFFINE;
        this.llah.hashTableSize = Integer.MAX_VALUE;
    }

    public ConfigUchiyaMarker setTo(ConfigUchiyaMarker src) {
        this.markerWidth = src.markerWidth;
        this.markerHeight = src.markerHeight;
        this.threshold.setTo(src.threshold);
        this.llah.setTo(src.llah);
        this.ransac.setTo(src.ransac);
        this.contourRule = src.contourRule;
        this.contourMinimumLength.setTo(src.contourMinimumLength);
        this.contourMaximumLength.setTo(src.contourMaximumLength);
        this.maxDistanceFromEllipse = src.maxDistanceFromEllipse;
        this.minimumMinorAxis.setTo(src.minimumMinorAxis);
        this.maxMajorToMinorRatio = src.maxMajorToMinorRatio;
        this.checkEdge.setTo(src.checkEdge);
        return this;
    }

    public void checkValidity() {
        this.llah.checkValidity();
        this.contourMinimumLength.checkValidity();
        this.contourMaximumLength.checkValidity();
        if (this.markerWidth <= 0.0) {
            throw new IllegalArgumentException("Marker's width must set!");
        }
        if (this.markerHeight <= 0.0) {
            throw new IllegalArgumentException("Marker's height must set!");
        }
    }
}

