/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.interactivity;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

@Named
public class DefaultPrompter
implements Prompter {
    private final OutputHandler outputHandler;
    private final InputHandler inputHandler;

    @Inject
    public DefaultPrompter(OutputHandler outputHandler, InputHandler inputHandler) {
        this.outputHandler = outputHandler;
        this.inputHandler = inputHandler;
    }

    @Override
    public String prompt(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", e);
        }
        try {
            return this.inputHandler.readLine();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", e);
        }
    }

    @Override
    public String prompt(String message, String defaultReply) throws PrompterException {
        try {
            this.writePrompt(this.formatMessage(message, null, defaultReply));
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", e);
        }
        try {
            String line = this.inputHandler.readLine();
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            return line;
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", e);
        }
    }

    @Override
    public String prompt(String message, List<String> possibleValues, String defaultReply) throws PrompterException {
        String line;
        String formattedMessage = this.formatMessage(message, possibleValues, defaultReply);
        do {
            try {
                this.writePrompt(formattedMessage);
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present prompt", e);
            }
            try {
                line = this.inputHandler.readLine();
                if (line == null && defaultReply == null) {
                    throw new IOException("EOF");
                }
            }
            catch (IOException e) {
                throw new PrompterException("Failed to read user response", e);
            }
            if (StringUtils.isEmpty((String)line)) {
                line = defaultReply;
            }
            if (line == null || possibleValues.contains(line)) continue;
            try {
                this.outputHandler.writeLine("Invalid selection.");
            }
            catch (IOException e) {
                throw new PrompterException("Failed to present feedback", e);
            }
        } while (line == null || !possibleValues.contains(line));
        return line;
    }

    @Override
    public String prompt(String message, List<String> possibleValues) throws PrompterException {
        return this.prompt(message, possibleValues, null);
    }

    @Override
    public String promptForPassword(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", e);
        }
        try {
            return this.inputHandler.readPassword();
        }
        catch (IOException e) {
            throw new PrompterException("Failed to read user response", e);
        }
    }

    private String formatMessage(String message, List<String> possibleValues, String defaultReply) {
        StringBuilder formatted = new StringBuilder(message.length() * 2);
        formatted.append(message);
        if (possibleValues != null && !possibleValues.isEmpty()) {
            formatted.append(" (");
            Iterator<String> it = possibleValues.iterator();
            while (it.hasNext()) {
                String possibleValue = it.next();
                formatted.append(possibleValue);
                if (!it.hasNext()) continue;
                formatted.append('/');
            }
            formatted.append(')');
        }
        if (defaultReply != null) {
            formatted.append(' ').append(defaultReply);
        }
        return formatted.toString();
    }

    private void writePrompt(String message) throws IOException {
        this.outputHandler.write(message + ": ");
    }

    @Override
    public void showMessage(String message) throws PrompterException {
        try {
            this.writePrompt(message);
        }
        catch (IOException e) {
            throw new PrompterException("Failed to present prompt", e);
        }
    }
}

