/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.heading.anchor;

import org.commonmark.Extension;
import org.commonmark.ext.heading.anchor.internal.HeadingIdAttributeProvider;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.AttributeProviderContext;
import org.commonmark.renderer.html.AttributeProviderFactory;
import org.commonmark.renderer.html.HtmlRenderer;

public class HeadingAnchorExtension
implements HtmlRenderer.HtmlRendererExtension {
    private final String defaultId;
    private final String idPrefix;
    private final String idSuffix;

    private HeadingAnchorExtension(Builder builder) {
        this.defaultId = builder.defaultId;
        this.idPrefix = builder.idPrefix;
        this.idSuffix = builder.idSuffix;
    }

    public static Extension create() {
        return new HeadingAnchorExtension(HeadingAnchorExtension.builder());
    }

    public static Builder builder() {
        return new Builder();
    }

    public void extend(HtmlRenderer.Builder rendererBuilder) {
        rendererBuilder.attributeProviderFactory(new AttributeProviderFactory(){

            public AttributeProvider create(AttributeProviderContext context) {
                return HeadingIdAttributeProvider.create(HeadingAnchorExtension.this.defaultId, HeadingAnchorExtension.this.idPrefix, HeadingAnchorExtension.this.idSuffix);
            }
        });
    }

    public static class Builder {
        private String defaultId = "id";
        private String idPrefix = "";
        private String idSuffix = "";

        public Builder defaultId(String value) {
            this.defaultId = value;
            return this;
        }

        public Builder idPrefix(String value) {
            this.idPrefix = value;
            return this;
        }

        public Builder idSuffix(String value) {
            this.idSuffix = value;
            return this;
        }

        public Extension build() {
            return new HeadingAnchorExtension(this);
        }
    }
}

