/*
 * Decompiled with CFR 0.152.
 */
package fxsampler.util;

import fxsampler.FXSamplerProject;
import fxsampler.Sample;
import fxsampler.model.EmptySample;
import fxsampler.model.Project;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class SampleScanner {
    private static List<String> ILLEGAL_CLASS_NAMES = new ArrayList<String>();
    private static final Map<String, FXSamplerProject> packageToProjectMap;
    private final Map<String, Project> projectsMap = new HashMap<String, Project>();

    public Map<String, Project> discoverSamples() {
        Class[] results = new Class[]{};
        try {
            results = this.loadFromPathScanning();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Class sampleClass : results) {
            if (!Sample.class.isAssignableFrom(sampleClass) || sampleClass.isInterface() || Modifier.isAbstract(sampleClass.getModifiers()) || sampleClass == EmptySample.class) continue;
            Sample sample = null;
            try {
                sample = (Sample)sampleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (sample == null || !sample.isVisible()) continue;
            String packageName = sampleClass.getPackage().getName();
            for (String key : packageToProjectMap.keySet()) {
                Project project;
                if (!packageName.contains(key)) continue;
                FXSamplerProject fxSamplerProject = packageToProjectMap.get(key);
                String prettyProjectName = fxSamplerProject.getProjectName();
                if (!this.projectsMap.containsKey(prettyProjectName)) {
                    project = new Project(prettyProjectName, key);
                    project.setModuleName(fxSamplerProject.getModuleName());
                    project.setWelcomePage(fxSamplerProject.getWelcomePage());
                    this.projectsMap.put(prettyProjectName, project);
                } else {
                    project = this.projectsMap.get(prettyProjectName);
                }
                project.addSample(packageName, sample);
            }
        }
        return this.projectsMap;
    }

    private Class<?>[] loadFromPathScanning() throws IOException {
        LinkedHashSet classes = new LinkedHashSet();
        ModuleLayer.boot().configuration().modules().stream().map(ResolvedModule::reference).filter(rm -> !SampleScanner.isSystemModule(rm.descriptor().name())).forEach(mref -> {
            try (ModuleReader reader = mref.open();){
                reader.list().forEach(c -> {
                    Class<?> clazz = this.processClassName((String)c);
                    if (clazz != null) {
                        classes.add(clazz);
                    }
                });
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        return classes.toArray(new Class[classes.size()]);
    }

    private Class<?> processClassName(String name) {
        String className = name.replace("\\", ".");
        if ((className = className.replace("/", ".")).contains("$")) {
            return null;
        }
        if (className.contains(".bin")) {
            className = className.substring(className.indexOf(".bin") + 4);
            className = className.replace(".bin", "");
        }
        if (className.startsWith(".")) {
            className = className.substring(1);
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz;
    }

    private static boolean isSystemModule(String moduleName) {
        return moduleName.startsWith("java.") || moduleName.startsWith("javax.") || moduleName.startsWith("javafx.") || moduleName.startsWith("jdk.") || moduleName.startsWith("oracle.");
    }

    static {
        ILLEGAL_CLASS_NAMES.add("/com/javafx/main/Main.class");
        ILLEGAL_CLASS_NAMES.add("/com/javafx/main/NoJavaFXFallback.class");
        packageToProjectMap = new HashMap<String, FXSamplerProject>();
        System.out.println("Initialising FXSampler sample scanner...");
        System.out.println("\tDiscovering projects...");
        ServiceLoader<FXSamplerProject> loader = ServiceLoader.load(FXSamplerProject.class);
        for (FXSamplerProject project : loader) {
            String projectName = project.getProjectName();
            String basePackage = project.getSampleBasePackage();
            packageToProjectMap.put(basePackage, project);
            System.out.println("\t\tFound project '" + projectName + "', with sample base package '" + basePackage + "'");
        }
        if (packageToProjectMap.isEmpty()) {
            System.out.println("\tError: Did not find any projects!");
        }
    }
}

