/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.paths;

import java.util.Iterator;
import org.dmfs.iterators.ArrayIterator;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.IdempotentEncoded;

public final class StructuredPath
implements Path {
    private final UriEncoded[] mPathSegments;

    public StructuredPath(UriEncoded ... segments) {
        this.mPathSegments = (UriEncoded[])segments.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.mPathSegments.length == 0;
    }

    @Override
    public boolean isAbsolute() {
        return this.mPathSegments.length > 0 && IdempotentEncoded.EMPTY.equals(this.mPathSegments[0]);
    }

    @Override
    public Iterator<UriEncoded> iterator() {
        return new ArrayIterator((Object[])this.mPathSegments);
    }
}

