/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.uris;

import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.Path;
import org.dmfs.rfc3986.Query;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.paths.EmptyPath;

public final class RelativeUri
implements Uri {
    private final Path mPath;
    private final Optional<Query> mQuery;
    private final Optional<Fragment> mFragment;

    public RelativeUri(Path path) {
        this(path, (Optional<Query>)Absent.absent(), (Optional<Fragment>)Absent.absent());
    }

    public RelativeUri(Query query) {
        this((Path)EmptyPath.INSTANCE, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)Absent.absent());
    }

    public RelativeUri(Fragment fragment) {
        this((Path)EmptyPath.INSTANCE, (Optional<Query>)Absent.absent(), (Optional<Fragment>)new Present((Object)fragment));
    }

    public RelativeUri(Path path, Query query) {
        this(path, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)Absent.absent());
    }

    public RelativeUri(Query query, Fragment fragment) {
        this((Path)EmptyPath.INSTANCE, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)new Present((Object)fragment));
    }

    public RelativeUri(Path path, Query query, Fragment fragment) {
        this(path, (Optional<Query>)new Present((Object)query), (Optional<Fragment>)new Present((Object)fragment));
    }

    public RelativeUri(Path path, Optional<Query> query, Optional<Fragment> fragment) {
        this.mPath = path;
        this.mQuery = query;
        this.mFragment = fragment;
    }

    @Override
    public Optional<? extends Scheme> scheme() {
        return Absent.absent();
    }

    @Override
    public Optional<? extends Authority> authority() {
        return Absent.absent();
    }

    @Override
    public Path path() {
        return this.mPath;
    }

    @Override
    public Optional<? extends Query> query() {
        return this.mQuery;
    }

    @Override
    public Optional<? extends Fragment> fragment() {
        return this.mFragment;
    }

    @Override
    public boolean isHierarchical() {
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }
}

