/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.uris;

import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.Authority;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.Query;
import org.dmfs.rfc3986.Scheme;
import org.dmfs.rfc3986.Uri;

public final class Text
implements CharSequence {
    private final Uri mUri;
    private String mString;

    public Text(Uri uri) {
        this.mUri = uri;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    public String toString() {
        if (this.mString == null) {
            Optional<? extends Fragment> optFragment;
            Optional<? extends Authority> optAuthority;
            StringBuilder stringBuilder = new StringBuilder(128);
            if (this.mUri.scheme().isPresent()) {
                stringBuilder.append(((Scheme)this.mUri.scheme().value()).toString());
                stringBuilder.append(':');
            }
            if ((optAuthority = this.mUri.authority()).isPresent()) {
                stringBuilder.append('/');
                stringBuilder.append('/');
                stringBuilder.append(new org.dmfs.rfc3986.authorities.Text((Authority)optAuthority.value()));
            }
            stringBuilder.append(new org.dmfs.rfc3986.paths.Text(this.mUri.path()));
            Optional<? extends Query> optQuery = this.mUri.query();
            if (optQuery.isPresent()) {
                stringBuilder.append('?');
                stringBuilder.append((CharSequence)optQuery.value());
            }
            if ((optFragment = this.mUri.fragment()).isPresent()) {
                stringBuilder.append('#');
                stringBuilder.append((CharSequence)optFragment.value());
            }
            this.mString = stringBuilder.toString();
        }
        return this.mString;
    }
}

