/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf.viaXSLFO;

import java.io.File;
import java.io.OutputStream;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.pdf.PdfConversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversion
extends PdfConversion {
    public static Logger log = LoggerFactory.getLogger(Conversion.class);
    protected WordprocessingMLPackage wordMLPackage = null;
    private static File saveFO;

    public Conversion(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public void setSaveFO(File save) {
        saveFO = save;
    }

    @Override
    public void outputXSLFO(OutputStream os, PdfSettings settings) throws Docx4JException {
        this.setupSettings(settings, "application/pdf");
        Docx4J.toFO((FOSettings)settings, (OutputStream)os, (int)1);
    }

    @Override
    public void output(OutputStream os, PdfSettings settings) throws Docx4JException {
        this.setupSettings(settings, "application/xml-fo");
        Docx4J.toPDF((WordprocessingMLPackage)this.wordMLPackage, (OutputStream)os);
    }

    protected void setupSettings(FOSettings settings, String mime) throws Docx4JException {
        if (this.wordMLPackage != null && settings.getOpcPackage() == null) {
            settings.setOpcPackage((OpcPackage)this.wordMLPackage);
        }
        if (saveFO != null && settings.getFoDumpFile() == null) {
            settings.setFoDumpFile(saveFO);
        }
        settings.setApacheFopMime(mime);
    }
}

