/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.common.entity.DtpExecutorProps;
import org.dromara.dynamictp.common.entity.TpExecutorProps;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.springframework.core.env.Environment;

public final class DtpPropertiesBinderUtil {
    private DtpPropertiesBinderUtil() {
    }

    public static void tryResetWithGlobalConfig(Object source, DtpProperties dtpProperties) {
        if (Objects.isNull(dtpProperties.getGlobalExecutorProps())) {
            return;
        }
        if (CollectionUtils.isNotEmpty(dtpProperties.getExecutors())) {
            DtpPropertiesBinderUtil.tryResetCusExecutors(dtpProperties, source);
        }
        DtpPropertiesBinderUtil.tryResetAdapterExecutors(dtpProperties, source);
    }

    private static void tryResetCusExecutors(DtpProperties dtpProperties, Object source) {
        List<Field> dtpPropsFields = ReflectionUtil.getAllFields(DtpExecutorProps.class);
        DtpExecutorProps globalExecutorProps = dtpProperties.getGlobalExecutorProps();
        int[] idx = new int[]{0};
        dtpProperties.getExecutors().forEach(executor -> {
            dtpPropsFields.forEach(field -> {
                String propKey = "spring.dynamic.tp.executors[" + idx[0] + "]." + field.getName();
                DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
            });
            String executorFieldNamePrefix = "spring.dynamic.tp.executors[" + idx[0] + "]";
            DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, executor, executorFieldNamePrefix);
            idx[0] = idx[0] + 1;
        });
    }

    private static void tryResetAdapterExecutors(DtpProperties dtpProperties, Object source) {
        List<Field> dtpPropertiesFields = ReflectionUtil.getAllFields(DtpProperties.class);
        List<Field> tpExecutorPropFields = ReflectionUtil.getAllFields(TpExecutorProps.class);
        DtpExecutorProps globalExecutorProps = dtpProperties.getGlobalExecutorProps();
        dtpPropertiesFields.forEach(dtpPropertiesField -> {
            ParameterizedType paramType;
            Type[] argTypes;
            Object candidateExecutor = ReflectUtil.getFieldValue((Object)dtpProperties, (Field)dtpPropertiesField);
            if (Objects.isNull(candidateExecutor)) {
                return;
            }
            String candidateExecutorFieldName = dtpPropertiesField.getName();
            if (dtpPropertiesField.getType().isAssignableFrom(TpExecutorProps.class)) {
                tpExecutorPropFields.forEach(field -> DtpPropertiesBinderUtil.setBasicField(source, field, candidateExecutorFieldName, candidateExecutor));
                String executorFieldNamePrefix = "spring.dynamic.tp." + dtpPropertiesField.getName();
                DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, candidateExecutor, executorFieldNamePrefix);
            } else if (dtpPropertiesField.getGenericType() instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)dtpPropertiesField.getGenericType()).getActualTypeArguments()).length == 1 && argTypes[0].equals(TpExecutorProps.class)) {
                List executors = (List)candidateExecutor;
                if (CollectionUtils.isEmpty((Collection)executors)) {
                    return;
                }
                int[] idx = new int[]{0};
                executors.forEach(executor -> {
                    tpExecutorPropFields.forEach(field -> DtpPropertiesBinderUtil.setBasicField(source, field, candidateExecutorFieldName, executor, idx));
                    String executorFieldNamePrefix = "spring.dynamic.tp." + candidateExecutorFieldName + "[" + idx[0] + "]";
                    DtpPropertiesBinderUtil.setCollectionField(source, globalExecutorProps, executor, executorFieldNamePrefix);
                    idx[0] = idx[0] + 1;
                });
            }
        });
    }

    private static Object getProperty(String key, Object environment) {
        if (environment instanceof Environment) {
            Environment env = (Environment)environment;
            return env.getProperty(key);
        }
        if (environment instanceof Map) {
            Map properties = (Map)environment;
            return properties.get(key);
        }
        return null;
    }

    private static boolean contains(String key, Object environment) {
        if (environment instanceof Environment) {
            Environment env = (Environment)environment;
            return env.containsProperty(key);
        }
        if (environment instanceof Map) {
            Map properties = (Map)environment;
            return properties.containsKey(key);
        }
        return false;
    }

    private static void setBasicField(Object source, Field field, String executorFieldName, Object executor, int[] idx) {
        String propKey = "spring.dynamic.tp." + executorFieldName + "[" + idx[0] + "]." + field.getName();
        DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
    }

    private static void setBasicField(Object source, Field field, String executorFieldName, Object executor) {
        String propKey = "spring.dynamic.tp." + executorFieldName + "." + field.getName();
        DtpPropertiesBinderUtil.setBasicField(source, field, executor, propKey);
    }

    private static void setBasicField(Object source, Field field, Object executor, String propKey) {
        Object propVal = DtpPropertiesBinderUtil.getProperty(propKey, source);
        if (Objects.nonNull(propVal)) {
            return;
        }
        Object globalFieldVal = DtpPropertiesBinderUtil.getProperty("spring.dynamic.tp.globalExecutorProps." + field.getName(), source);
        if (Objects.isNull(globalFieldVal)) {
            return;
        }
        ReflectUtil.setFieldValue((Object)executor, (String)field.getName(), (Object)globalFieldVal);
    }

    private static void setCollectionField(Object source, DtpExecutorProps globalExecutorProps, Object executor, String prefix) {
        if (!DtpPropertiesBinderUtil.contains(prefix + ".taskWrapperNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getTaskWrapperNames())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"taskWrapperNames", globalExecutorProps.getTaskWrapperNames());
        }
        if (!DtpPropertiesBinderUtil.contains(prefix + ".platformIds[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getPlatformIds())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"platformIds", globalExecutorProps.getPlatformIds());
        }
        if (!DtpPropertiesBinderUtil.contains(prefix + ".notifyItems[0].type", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getNotifyItems())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"notifyItems", globalExecutorProps.getNotifyItems());
        }
        if (!DtpPropertiesBinderUtil.contains(prefix + ".awareNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getAwareNames())) {
            ReflectUtil.setFieldValue((Object)executor, (String)"awareNames", globalExecutorProps.getAwareNames());
        }
        try {
            if (!DtpPropertiesBinderUtil.contains(prefix + ".pluginNames[0]", source) && CollectionUtils.isNotEmpty(globalExecutorProps.getPluginNames())) {
                ReflectUtil.setFieldValue((Object)executor, (String)"pluginNames", globalExecutorProps.getPluginNames());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

