/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.matrixTools;

import org.dromara.easyai.matrixTools.Matrix;

public class MatrixList {
    private int pointerX;
    private int pointerY;
    private int capacity = 256;
    private boolean addRow;
    private Matrix matrix;

    public int getX() {
        return this.pointerX;
    }

    public int getY() {
        return this.pointerY;
    }

    private void copy(Matrix myMatrix) throws Exception {
        for (int i = 0; i < this.pointerX; ++i) {
            for (int j = 0; j < this.pointerY; ++j) {
                myMatrix.setNub(i, j, this.matrix.getNumber(i, j));
            }
        }
        this.matrix = myMatrix;
    }

    public Matrix getMatrix() throws Exception {
        Matrix myMatrix = new Matrix(this.pointerX, this.pointerY);
        for (int i = 0; i < this.pointerX; ++i) {
            for (int j = 0; j < this.pointerY; ++j) {
                myMatrix.setNub(i, j, this.matrix.getNumber(i, j));
            }
        }
        return myMatrix;
    }

    private void insert(Matrix addMatrix) throws Exception {
        int startY;
        int startX;
        int ySize;
        int xSize;
        if (this.addRow) {
            xSize = this.pointerX + addMatrix.getX();
            ySize = this.pointerY;
            startX = this.pointerX;
            startY = 0;
        } else {
            xSize = this.pointerX;
            ySize = this.pointerY + addMatrix.getY();
            startX = 0;
            startY = this.pointerY;
        }
        for (int i = startX; i < xSize; ++i) {
            for (int j = startY; j < ySize; ++j) {
                this.matrix.setNub(i, j, addMatrix.getNumber(i - startX, j - startY));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Matrix addMatrix) throws Exception {
        if (addMatrix == null) return;
        if (this.addRow) {
            if (this.pointerY != addMatrix.getY()) throw new Exception("\u5411\u884c\u6dfb\u52a0\uff0c\u5217\u6570\u4e0d\u4e00\u81f4");
            int x = addMatrix.getX();
            if (this.pointerX + x > this.matrix.getX()) {
                this.copy(new Matrix(this.pointerX + x + this.capacity, this.pointerY));
            }
            this.insert(addMatrix);
            this.pointerX += x;
            return;
        } else {
            if (this.pointerX != addMatrix.getX()) throw new Exception("\u5411\u5217\u6dfb\u52a0\uff0c\u884c\u6570\u4e0d\u4e00\u81f4");
            int y = addMatrix.getY();
            if (this.pointerY + y > this.matrix.getY()) {
                this.copy(new Matrix(this.pointerX, this.pointerY + y + this.capacity));
            }
            this.insert(addMatrix);
            this.pointerY += y;
        }
    }

    public MatrixList(Matrix firstMatrix, boolean addRow, int capacity) throws Exception {
        this.capacity = capacity;
        this.init(firstMatrix, addRow);
    }

    public MatrixList(Matrix firstMatrix, boolean addRow) throws Exception {
        this.init(firstMatrix, addRow);
    }

    private void init(Matrix firstMatrix, boolean addRow) throws Exception {
        this.addRow = addRow;
        this.pointerX = firstMatrix.getX();
        this.pointerY = firstMatrix.getY();
        this.matrix = addRow ? new Matrix(this.pointerX + this.capacity, this.pointerY) : new Matrix(this.pointerX, this.pointerY + this.capacity);
        for (int i = 0; i < this.pointerX; ++i) {
            for (int j = 0; j < this.pointerY; ++j) {
                this.matrix.setNub(i, j, firstMatrix.getNumber(i, j));
            }
        }
    }
}

