/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.matrixTools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dromara.easyai.matrixTools.CudaMatrix;
import org.dromara.easyai.matrixTools.FeatureDe;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixMulAccelerate;
import org.dromara.easyai.matrixTools.QRMatrix;
import org.dromara.easyai.matrixTools.SVDBody;

public class MatrixOperation {
    private final int coreNumber;
    private ExecutorService POOL;
    private static final CudaMatrix cudaMatrix = MatrixOperation.getCudaMatrix();

    private static CudaMatrix getCudaMatrix() {
        ServiceLoader<CudaMatrix> loader = ServiceLoader.load(CudaMatrix.class);
        Iterator<CudaMatrix> iterator = loader.iterator();
        if (iterator.hasNext()) {
            CudaMatrix cm = iterator.next();
            try {
                cm.init();
                return cm;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MatrixOperation() {
        this.coreNumber = 1;
    }

    public MatrixOperation(int coreNumber) {
        this.coreNumber = coreNumber;
        if (coreNumber > 1) {
            this.POOL = Executors.newFixedThreadPool(coreNumber);
        }
    }

    public List<Float> rowVectorToList(Matrix matrix) throws Exception {
        ArrayList<Float> list = new ArrayList<Float>();
        for (int j = 0; j < matrix.getY(); ++j) {
            list.add(Float.valueOf(matrix.getNumber(0, j)));
        }
        return list;
    }

    public List<Matrix> addMatrixList(List<Matrix> matrixList1, List<Matrix> matrixList2) throws Exception {
        if (matrixList1.size() == matrixList2.size()) {
            ArrayList<Matrix> result = new ArrayList<Matrix>();
            int size = matrixList1.size();
            for (int i = 0; i < size; ++i) {
                result.add(this.add(matrixList1.get(i), matrixList2.get(i)));
            }
            return result;
        }
        throw new Exception("\u4e24\u4e2a\u77e9\u9635\u96c6\u5408\u76f8\u52a0\u5927\u5c0f\u4e0d\u76f8\u7b49");
    }

    public Matrix add(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix1.getY());
            int x = matrix1.getX();
            int y = matrix1.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) + matrix2.getNumber(i, j));
                }
            }
            return matrix;
        }
        throw new Exception("matrix is not equals");
    }

    public Matrix addThreeMatrix(Matrix matrix1, Matrix matrix2, Matrix matrix3) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY() && matrix1.getX() == matrix3.getX() && matrix1.getY() == matrix3.getY()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix1.getY());
            int x = matrix1.getX();
            int y = matrix1.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) + matrix2.getNumber(i, j) + matrix3.getNumber(i, j));
                }
            }
            return matrix;
        }
        throw new Exception("matrix is not equals");
    }

    public void center(Matrix matrix) throws Exception {
        float avgValue = matrix.getAVG();
        this.mathSub(matrix, avgValue);
    }

    public float getCrossEntropy(Matrix matrix1, Matrix matrix2) throws Exception {
        float sigMod = 0.0f;
        int x = matrix1.getX();
        int y = matrix1.getY();
        if (x == matrix2.getX() && y == matrix2.getY()) {
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    sigMod += matrix2.getNumber(i, j) * (float)Math.log(matrix1.getNumber(i, j));
                }
            }
            return -sigMod;
        }
        throw new Exception("matrix is not equals");
    }

    public Matrix softMaxByMatrix(Matrix feature) throws Exception {
        int j;
        int i;
        float sigma = 0.0f;
        int x = feature.getX();
        int y = feature.getY();
        Matrix softMaxMatrix = new Matrix(x, y);
        for (i = 0; i < x; ++i) {
            for (j = 0; j < y; ++j) {
                float value = feature.getNumber(i, j);
                sigma = (float)Math.exp(value) + sigma;
            }
        }
        for (i = 0; i < x; ++i) {
            for (j = 0; j < y; ++j) {
                float eSelf = (float)Math.exp(feature.getNumber(i, j));
                float value = eSelf / sigma;
                softMaxMatrix.setNub(i, j, value);
            }
        }
        return softMaxMatrix;
    }

    public Matrix sub(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix1.getY());
            int x = matrix1.getX();
            int y = matrix1.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) - matrix2.getNumber(i, j));
                }
            }
            return matrix;
        }
        throw new Exception("matrix is not equals");
    }

    private int getLBPValue(Matrix matrix) throws Exception {
        int value = 0;
        float avg = matrix.getAVG();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == 1 && j == 1) continue;
                value <<= 1;
                if (!(matrix.getNumber(i, j) > avg)) continue;
                value |= 1;
            }
        }
        return value;
    }

    public Matrix lbpMatrix(Matrix addMatrix) throws Exception {
        int x = addMatrix.getX();
        int y = addMatrix.getY();
        Matrix matrix = new Matrix(x / 3, y / 3);
        for (int i = 0; i <= x - 3; i += 3) {
            for (int j = 0; j <= y - 3; j += 3) {
                Matrix aMatrix = addMatrix.getSonOfMatrix(i, j, 3, 3);
                int lbp = this.getLBPValue(aMatrix);
                matrix.setNub(i / 3, j / 3, lbp);
            }
        }
        return matrix;
    }

    public Matrix getLinearRegression(Matrix parameter, Matrix out) throws Exception {
        if (parameter.getX() == out.getX() && out.isVector()) {
            Matrix matrix1 = this.transPosition(parameter);
            Matrix matrix2 = this.mulMatrix(matrix1, parameter);
            Matrix matrix3 = this.getInverseMatrix(matrix2);
            if (matrix3.getX() == 1 && matrix3.getY() == 1) {
                return matrix3;
            }
            Matrix matrix4 = this.mulMatrix(matrix3, matrix1);
            return this.mulMatrix(matrix4, out);
        }
        throw new Exception("invalid regression matrix");
    }

    public float getEDistByMatrix(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            int x = matrix1.getX();
            int y = matrix1.getY();
            float sigma = 0.0f;
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    float sub = matrix1.getNumber(i, j) - matrix2.getNumber(i, j);
                    sigma += (float)Math.pow(sub, 2.0);
                }
            }
            return sigma / (float)(x * y);
        }
        throw new Exception("two matrixes is not equals");
    }

    public float getEDist(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.isRowVector() && matrix2.isRowVector() && matrix1.getY() == matrix2.getY()) {
            Matrix matrix = this.sub(matrix1, matrix2);
            return this.getNorm(matrix);
        }
        throw new Exception("this matrix is not  rowVector or length different");
    }

    public float errorNub(Matrix matrix, Matrix avgMatrix) throws Exception {
        int y = matrix.getY();
        if (matrix.isRowVector() && avgMatrix.isRowVector() && y == avgMatrix.getY()) {
            float[] subAll = new float[y];
            for (int j = 0; j < y; ++j) {
                float sub;
                float mySelf = matrix.getNumber(0, j);
                float avg = avgMatrix.getNumber(0, j);
                subAll[j] = sub = (float)Math.pow(avg - mySelf, 2.0);
            }
            float sigma = 0.0f;
            for (int i = 0; i < y; ++i) {
                sigma += subAll[i];
            }
            return sigma / (float)y;
        }
        throw new Exception("this matrix is not  rowVector or length different");
    }

    public Matrix pushVector(Matrix myMatrix, Matrix matrix, boolean addRow) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix addMatrix;
            if (addRow) {
                if (matrix.getY() != myMatrix.getY()) {
                    throw new Exception("this matrix column is not equals");
                }
                addMatrix = new Matrix(myMatrix.getX() + 1, myMatrix.getY());
            } else {
                if (matrix.getX() != myMatrix.getX()) {
                    throw new Exception("this matrix row is not equals");
                }
                addMatrix = new Matrix(myMatrix.getX(), myMatrix.getY() + 1);
            }
            for (int i = 0; i < addMatrix.getX(); ++i) {
                for (int j = 0; j < addMatrix.getY(); ++j) {
                    if (addRow) {
                        if (i == addMatrix.getX() - 1) {
                            addMatrix.setNub(i, j, matrix.getNumber(0, j));
                            continue;
                        }
                        addMatrix.setNub(i, j, myMatrix.getNumber(i, j));
                        continue;
                    }
                    if (j == addMatrix.getY() - 1) {
                        addMatrix.setNub(i, j, matrix.getNumber(i, 0));
                        continue;
                    }
                    addMatrix.setNub(i, j, myMatrix.getNumber(i, j));
                }
            }
            return addMatrix;
        }
        throw new Exception("this matrix is not a vector");
    }

    public Matrix push(Matrix matrix, float nub, boolean isRow) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix myMatrix;
            int nubs;
            if (isRow) {
                nubs = matrix.getY() + 1;
                myMatrix = new Matrix(1, nubs);
            } else {
                nubs = matrix.getX() + 1;
                myMatrix = new Matrix(nubs, 1);
            }
            for (int i = 0; i < nubs; ++i) {
                if (i == nubs - 1) {
                    if (isRow) {
                        myMatrix.setNub(0, i, nub);
                        continue;
                    }
                    myMatrix.setNub(i, 0, nub);
                    continue;
                }
                if (isRow) {
                    myMatrix.setNub(0, i, matrix.getNumber(0, i));
                    continue;
                }
                myMatrix.setNub(i, 0, matrix.getNumber(i, 0));
            }
            return myMatrix;
        }
        throw new Exception("this matrix is not a vector");
    }

    public Matrix getPoolVector(Matrix matrix) throws Exception {
        if (matrix.getX() == 1 || matrix.getY() == 1) {
            Matrix vector;
            int nub;
            boolean isRow = false;
            if (matrix.getX() == 1) {
                isRow = true;
                nub = matrix.getY() / 4;
                vector = new Matrix(1, nub);
            } else {
                nub = matrix.getX() / 4;
                vector = new Matrix(nub, 1);
            }
            int k = 0;
            for (int i = 0; i < nub * 4 - 3; i += 4) {
                float max = 0.0f;
                if (isRow) {
                    max = matrix.getNumber(0, i);
                    max = this.getMax(max, matrix.getNumber(0, i + 1));
                    max = this.getMax(max, matrix.getNumber(0, i + 2));
                    max = this.getMax(max, matrix.getNumber(0, i + 3));
                    vector.setNub(0, k, max);
                } else {
                    max = matrix.getNumber(i, 0);
                    max = this.getMax(max, matrix.getNumber(i + 1, 0));
                    max = this.getMax(max, matrix.getNumber(i + 2, 0));
                    max = this.getMax(max, matrix.getNumber(i + 3, 0));
                    vector.setNub(k, 0, max);
                }
                ++k;
            }
            return vector;
        }
        throw new Exception("this matrix is not a vector");
    }

    private float getMax(float o1, float o2) {
        return Math.max(o1, o2);
    }

    public Matrix matrixToVector(Matrix matrix, boolean isRow) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix myMatrix = isRow ? new Matrix(1, x * y) : new Matrix(x * y, 1);
        int t = 0;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (isRow) {
                    myMatrix.setNub(0, t, matrix.getNumber(i, j));
                } else {
                    myMatrix.setNub(t, 0, matrix.getNumber(i, j));
                }
                ++t;
            }
        }
        return myMatrix;
    }

    public float innerProduct(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getX() == matrix2.getX() && matrix1.getY() == matrix2.getY()) {
            float sigma = 0.0f;
            for (int i = 0; i < matrix1.getX(); ++i) {
                for (int j = 0; j < matrix1.getY(); ++j) {
                    sigma += matrix1.getNumber(i, j) * matrix2.getNumber(i, j);
                }
            }
            return sigma;
        }
        throw new Exception("\u4e24\u4e2a\u5411\u91cf\u7684\u957f\u5bbd\u5fc5\u987b\u76f8\u540c");
    }

    public float getNorm(Matrix matrix) throws Exception {
        if (matrix.getY() == 1 || matrix.getX() == 1) {
            float nub = 0.0f;
            for (int i = 0; i < matrix.getX(); ++i) {
                for (int j = 0; j < matrix.getY(); ++j) {
                    nub = (float)Math.pow(matrix.getNumber(i, j), 2.0) + nub;
                }
            }
            return (float)Math.sqrt(nub);
        }
        throw new Exception("this matrix is not vector");
    }

    public float getNormCos(Matrix matrix1, Matrix matrix2) throws Exception {
        float inner = this.innerProduct(matrix1, matrix2);
        float mulNorm = this.getNorm(matrix1) * this.getNorm(matrix2);
        return inner / mulNorm;
    }

    public Matrix transPosition(Matrix matrix) throws Exception {
        Matrix myMatrix = new Matrix(matrix.getY(), matrix.getX());
        for (int i = 0; i < matrix.getY(); ++i) {
            Matrix matrixColumn = matrix.getColumn(i);
            for (int j = 0; j < matrixColumn.getX(); ++j) {
                float myNode = matrixColumn.getNumber(j, 0);
                myMatrix.setNub(i, j, myNode);
            }
        }
        return myMatrix;
    }

    public float convolution(Matrix matrix, Matrix kernel, int x, int y) throws Exception {
        float allNub = 0.0f;
        int xr = 0;
        int yr = 0;
        int kxMax = kernel.getX();
        int kyMax = kernel.getY();
        for (int i = 0; i < kxMax; ++i) {
            xr = i + x;
            for (int j = 0; j < kyMax; ++j) {
                yr = j + y;
                allNub = matrix.getNumber(xr, yr) * kernel.getNumber(i, j) + allNub;
            }
        }
        return allNub;
    }

    public float getKernelNub(Matrix matrix, Matrix kernel) throws Exception {
        float allNub = 0.0f;
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                allNub = matrix.getNumber(i, j) * kernel.getNumber(i, j) + allNub;
            }
        }
        return allNub;
    }

    public int inverseNumber(float[] myInverse) {
        int size = myInverse.length;
        int inverserNumber = 0;
        for (int i = 0; i < size; ++i) {
            float element = myInverse[i];
            for (int j = i + 1; j < size; ++j) {
                if (!(myInverse[j] < element)) continue;
                ++inverserNumber;
            }
        }
        return inverserNumber;
    }

    public Matrix getInverseMatrix(Matrix matrix) throws Exception {
        float def = matrix.getDet();
        if (def != 0.0f) {
            def = 1.0f / def;
            Matrix myMatrix = this.adjointMatrix(matrix);
            this.mathMul(myMatrix, def);
            return myMatrix;
        }
        return new Matrix(1, 1);
    }

    public Matrix adjointMatrix(Matrix matrix) throws Exception {
        Matrix myMatrix = new Matrix(matrix.getX(), matrix.getY());
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                myMatrix.setNub(i, j, this.algebraicCofactor(matrix, i, j));
            }
        }
        return this.transPosition(myMatrix);
    }

    public float algebraicCofactor(Matrix matrix, int row, int column) throws Exception {
        if (row >= 0 && column >= 0 && row < matrix.getX() && column < matrix.getY()) {
            int x = matrix.getX() - 1;
            int y = matrix.getY() - 1;
            int ij = row + column + 2;
            int oldX = 0;
            int oldY = 0;
            boolean isXNext = false;
            Matrix myMatrix = new Matrix(x, y);
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    if (i == row && !isXNext) {
                        isXNext = true;
                        ++oldX;
                    }
                    if (j == column) {
                        ++oldY;
                    }
                    myMatrix.setNub(i, j, matrix.getNumber(oldX, oldY));
                    ++oldY;
                }
                ++oldX;
                oldY = 0;
            }
            float dm = myMatrix.getDet();
            if (ij % 2 != 0) {
                dm = -dm;
            }
            return dm;
        }
        throw new Exception("row or column index Beyond the limit");
    }

    public Matrix matrixSoftMaxPd(Matrix qkt, Matrix errorMatrix, float wordVectorDimension) throws Exception {
        if (null != cudaMatrix) {
            return cudaMatrix.matrixSoftMaxPd(qkt, errorMatrix, wordVectorDimension);
        }
        float param = (float)Math.sqrt(wordVectorDimension);
        int x = qkt.getX();
        int y = qkt.getY();
        Matrix grMatrix = new Matrix(x, y);
        for (int i = 0; i < x; ++i) {
            Matrix qr = qkt.getRow(i);
            for (int j = 0; j < y; ++j) {
                float jValue = qr.getNumber(0, j);
                int z = qr.getY();
                float sigma = 0.0f;
                for (int k = 0; k < z; ++k) {
                    float kValue = qr.getNumber(0, k);
                    float error = errorMatrix.getNumber(i, k);
                    float er = k != j ? -error * kValue * jValue : jValue * (1.0f - jValue) * error;
                    sigma += er;
                }
                float gr = sigma / param;
                grMatrix.setNub(i, j, gr);
            }
        }
        return grMatrix;
    }

    public void softMax(Matrix matrix) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            Matrix row = matrix.getRow(i);
            float sigma = this.getRowSoftMaxSigma(row);
            for (int j = 0; j < matrix.getY(); ++j) {
                float self = row.getNumber(0, j);
                float eSelf = (float)Math.exp(self);
                matrix.setNub(i, j, eSelf / sigma);
            }
        }
    }

    private float getRowSoftMaxSigma(Matrix row) throws Exception {
        float sigma = 0.0f;
        for (int i = 0; i < row.getY(); ++i) {
            float value = row.getNumber(0, i);
            sigma = (float)Math.exp(value) + sigma;
        }
        return sigma;
    }

    public Matrix matrixPointDiv(Matrix matrix1, Matrix matrix2) throws Exception {
        int x = matrix1.getX();
        int y = matrix1.getY();
        Matrix matrix = new Matrix(x, y);
        if (matrix2.getX() == x && matrix2.getY() == y) {
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    matrix.setNub(i, j, matrix1.getNumber(i, j) / matrix2.getNumber(i, j));
                }
            }
        } else {
            throw new Exception("two matrix is not equals");
        }
        return matrix;
    }

    public Matrix matrixMulPd(Matrix errorMatrix, Matrix first, Matrix second, boolean isFirstPd) throws Exception {
        Matrix matrix = isFirstPd ? this.mulMatrix(errorMatrix, this.transPosition(second)) : this.mulMatrix(this.transPosition(first), errorMatrix);
        return matrix;
    }

    public float getSdByMatrix(Matrix m, float avg, float e) throws Exception {
        float var = 0.0f;
        float size = m.getX() * m.getY();
        for (int i = 0; i < m.getX(); ++i) {
            for (int j = 0; j < m.getY(); ++j) {
                var += (float)Math.pow(m.getNumber(i, j) - avg, 2.0);
            }
        }
        return (float)Math.sqrt(var / size + e);
    }

    private Matrix mulMatrixOne(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getY() == matrix2.getX()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix2.getY());
            for (int i = 0; i < matrix1.getX(); ++i) {
                Matrix matrixRow = matrix1.getRow(i);
                for (int j = 0; j < matrix2.getY(); ++j) {
                    Matrix matrixColumn = matrix2.getColumn(j);
                    float columnAllNumber = 0.0f;
                    for (int h = 0; h < matrixColumn.getX(); ++h) {
                        float columnNumber = matrixColumn.getNumber(h, 0);
                        float rowNumber = matrixRow.getNumber(0, h);
                        float nowNumber = columnNumber * rowNumber;
                        columnAllNumber += nowNumber;
                    }
                    matrix.setNub(i, j, columnAllNumber);
                }
            }
            return matrix;
        }
        throw new Exception("row is not equals column");
    }

    private Matrix mulMatrixMany(Matrix matrix1, Matrix matrix2) throws Exception {
        if (matrix1.getY() == matrix2.getX()) {
            Matrix matrix = new Matrix(matrix1.getX(), matrix2.getY());
            CountDownLatch countDownLatch = new CountDownLatch(matrix1.getX() * matrix2.getY());
            int x = matrix1.getX();
            int y = matrix2.getY();
            for (int i = 0; i < x; ++i) {
                for (int j = 0; j < y; ++j) {
                    MatrixMulAccelerate matrixMulAccelerate = new MatrixMulAccelerate(matrix1, matrix2, matrix, i, j, countDownLatch);
                    this.POOL.execute(matrixMulAccelerate);
                }
            }
            countDownLatch.await();
            return matrix;
        }
        throw new Exception("row is not equals column");
    }

    public Matrix mulMatrix(Matrix matrix1, Matrix matrix2) throws Exception {
        if (null != cudaMatrix) {
            return cudaMatrix.mulMatrix(matrix1, matrix2);
        }
        if (this.coreNumber > 1) {
            return this.mulMatrixMany(matrix1, matrix2);
        }
        return this.mulMatrixOne(matrix1, matrix2);
    }

    public Matrix mathMulBySelf(Matrix matrix, float nub) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        Matrix myMatrix = new Matrix(x, y);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                myMatrix.setNub(i, j, matrix.getNumber(i, j) * nub);
            }
        }
        return myMatrix;
    }

    public void mathMul(Matrix matrix, float nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) * nub);
            }
        }
    }

    public void mathAdd(Matrix matrix, float nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) + nub);
            }
        }
    }

    public void mathSub(Matrix matrix, float nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) - nub);
            }
        }
    }

    public void mathDiv(Matrix matrix, float nub) throws Exception {
        for (int i = 0; i < matrix.getX(); ++i) {
            for (int j = 0; j < matrix.getY(); ++j) {
                matrix.setNub(i, j, matrix.getNumber(i, j) / nub);
            }
        }
    }

    public List<Float> matrixToList(Matrix matrix) throws Exception {
        ArrayList<Float> list = new ArrayList<Float>();
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                list.add(Float.valueOf(matrix.getNumber(i, j)));
            }
        }
        return list;
    }

    public Matrix vectorToMatrix(Matrix vector, int xSize, int ySize) throws Exception {
        Matrix matrix = new Matrix(xSize, ySize);
        if (vector.isRowVector()) {
            for (int i = 0; i < xSize; ++i) {
                for (int j = 0; j < ySize; ++j) {
                    int index = i * ySize + j;
                    matrix.setNub(i, j, vector.getNumber(0, index));
                }
            }
        } else {
            for (int i = 0; i < xSize; ++i) {
                for (int j = 0; j < ySize; ++j) {
                    int index = i * ySize + j;
                    matrix.setNub(i, j, vector.getNumber(index, 0));
                }
            }
        }
        return matrix;
    }

    public Matrix ListToMatrix(List<Float> list, int matrixX, int matrixY) throws Exception {
        Matrix matrix = new Matrix(matrixX, matrixY);
        for (int i = 0; i < matrixX; ++i) {
            for (int j = 0; j < matrixY; ++j) {
                int index = i * matrixY + j;
                matrix.setNub(i, j, list.get(index).floatValue());
            }
        }
        return matrix;
    }

    public Matrix listToRowVector(List<Float> list) throws Exception {
        Matrix matrix = new Matrix(1, list.size());
        for (int i = 0; i < list.size(); ++i) {
            matrix.setNub(0, i, list.get(i).floatValue());
        }
        return matrix;
    }

    public Matrix listToRowVector(List<Float> list, int nub) throws Exception {
        Matrix matrix = new Matrix(1, nub);
        for (int i = 0; i < nub; ++i) {
            float n = 0.0f;
            if (list.size() > i) {
                n = list.get(i).floatValue();
            }
            matrix.setNub(0, i, n);
        }
        return matrix;
    }

    private void inputVector(Matrix matrix, Matrix feature, int index, int kenLen) throws Exception {
        int y = matrix.getY();
        for (int i = 0; i < y; ++i) {
            matrix.setNub(index, i, feature.getNumber(i / kenLen, i % kenLen));
        }
    }

    public Matrix im2col(Matrix matrix, int kernLen, int step) throws Exception {
        int ySize = kernLen * kernLen;
        int x = matrix.getX();
        int y = matrix.getY();
        int xSize = (x - (kernLen - step)) / step * ((y - (kernLen - step)) / step);
        Matrix myMatrix = new Matrix(xSize, ySize);
        int index = 0;
        for (int i = 0; i <= x - kernLen; i += step) {
            for (int j = 0; j <= y - kernLen; j += step) {
                this.inputVector(myMatrix, matrix.getSonOfMatrix(i, j, kernLen, kernLen), index, kernLen);
                ++index;
            }
        }
        return myMatrix;
    }

    public Matrix reverseIm2col(Matrix matrix, int kernLen, int step, int xSize, int ySize) throws Exception {
        int col = matrix.getY();
        int row = matrix.getX();
        int sub = kernLen - step;
        int y = (ySize - sub) / step;
        Matrix myMatrix = new Matrix(xSize, ySize);
        for (int i = 0; i < row; ++i) {
            int xz = i / y * step;
            int yz = i % y * step;
            for (int j = 0; j < col; ++j) {
                int xr = j / kernLen + xz;
                int yr = j % kernLen + yz;
                float value = myMatrix.getNumber(xr, yr) + matrix.getNumber(i, j);
                myMatrix.setNub(xr, yr, value);
            }
        }
        return myMatrix;
    }

    private void insertVectorValue(Matrix matrix, Matrix vector, int col) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        if (x == vector.getX() && vector.isVector() && y > col) {
            for (int i = 0; i < x; ++i) {
                matrix.setNub(i, col, vector.getNumber(i, 0));
            }
        } else {
            throw new Exception("\u6ce8\u5165\u5411\u91cf\u5f02\u5e38\uff0c\u6ce8\u5165\u7684\u5fc5\u987b\u4e3a\u5411\u91cf\uff0c\u4e14\u77e9\u9635\u7684\u5217\u6570\u5fc5\u987b\u4e0e\u5411\u91cf\u7684\u5217\u6570\u76f8\u7b49\uff0c\u4e14\u884c\u6570\u6ca1\u6709\u6ea2\u51fa");
        }
    }

    private void matrixSqrt(Matrix matrix) throws Exception {
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (i != j) continue;
                float value = (float)Math.sqrt(matrix.getNumber(i, j));
                matrix.setNub(i, j, value);
            }
        }
    }

    public Matrix pca(Matrix feature, Matrix avgMatrix, int time, int featureSize) throws Exception {
        if (feature.getX() == avgMatrix.getX() && feature.getY() == avgMatrix.getY()) {
            Matrix myMatrix = this.sub(feature, avgMatrix);
            return this.svd(myMatrix, time, featureSize).getMatrixU();
        }
        throw new Exception("\u7279\u5f81\u77e9\u9635\u4e0e\u5e73\u5747\u503c\u77e9\u9635\u5927\u5c0f\u4e0d\u76f8\u7b49");
    }

    public SVDBody svd(Matrix matrix, int time, int featureSize) throws Exception {
        Matrix tMatrix = this.transPosition(matrix);
        Matrix UA = this.mulMatrix(matrix, tMatrix);
        Matrix VA = this.mulMatrix(tMatrix, matrix);
        FeatureDe featureU = this.qrIteration(UA, time);
        FeatureDe featureV = this.qrIteration(VA, time);
        Matrix uValue = featureU.getFeatureValue();
        Matrix U = featureU.getFeatureMatrix();
        Matrix VT = this.transPosition(featureV.getFeatureMatrix());
        if (featureSize <= U.getY() && featureSize <= VT.getX()) {
            SVDBody svdBody = new SVDBody();
            Matrix rU = U.getSonOfMatrix(0, 0, U.getX(), featureSize);
            Matrix rVT = VT.getSonOfMatrix(0, 0, featureSize, VT.getY());
            Matrix feature = uValue.getSonOfMatrix(0, 0, featureSize, featureSize);
            this.matrixSqrt(feature);
            svdBody.setMatrixU(rU);
            svdBody.setMatrixVT(rVT);
            svdBody.setFeature(feature);
            return svdBody;
        }
        throw new Exception("\u6307\u5b9a\u5c3a\u5bf8\u8fc7\u5927");
    }

    public FeatureDe qrIteration(Matrix matrix, int time) throws Exception {
        Matrix V = null;
        Matrix featureValue = matrix.copy();
        for (int i = 0; i < time; ++i) {
            QRMatrix qrMatrix = this.qrd(featureValue);
            Matrix matrixQ = qrMatrix.getQ();
            Matrix matrixR = qrMatrix.getR();
            V = V == null ? matrixQ : this.mulMatrix(V, matrixQ);
            featureValue = this.mulMatrix(matrixR, matrixQ);
        }
        int x = featureValue.getX();
        int y = featureValue.getY();
        Matrix featureMatrix = new Matrix(x, y);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (i != j) continue;
                featureMatrix.setNub(i, j, featureValue.getNumber(i, j));
            }
        }
        FeatureDe featureDe = new FeatureDe();
        featureDe.setFeatureValue(featureMatrix);
        featureDe.setFeatureMatrix(V);
        return featureDe;
    }

    public QRMatrix qrd(Matrix matrix) throws Exception {
        int y;
        int x = matrix.getX();
        if (x == (y = matrix.getY())) {
            int i;
            Matrix schMatrix = new Matrix(x, y);
            Matrix R = new Matrix(x, x);
            Matrix normMatrix = new Matrix(x, x);
            for (i = 0; i < y; ++i) {
                Matrix xn = matrix.getColumn(i);
                R.setNub(i, i, 1.0f);
                if (i > 0) {
                    for (int k = 0; k < i; ++k) {
                        Matrix vn = schMatrix.getColumn(k);
                        float value = this.innerProduct(xn, vn) / this.innerProduct(vn, vn);
                        R.setNub(k, i, value);
                        this.mathMul(vn, value);
                        xn = this.sub(xn, vn);
                    }
                }
                float norm = this.getNorm(xn);
                normMatrix.setNub(i, i, norm);
                this.insertVectorValue(schMatrix, xn, i);
            }
            R = this.mulMatrix(normMatrix, R);
            for (i = 0; i < x; ++i) {
                float norm = normMatrix.getNumber(i, i);
                for (int j = 0; j < y; ++j) {
                    float value = schMatrix.getNumber(j, i) / norm;
                    schMatrix.setNub(j, i, value);
                }
            }
            QRMatrix qrMatrix = new QRMatrix();
            qrMatrix.setR(R);
            qrMatrix.setQ(schMatrix);
            return qrMatrix;
        }
        throw new Exception("\u8bf7\u5c06\u77e9\u9635\u5148\u5904\u7406\u4e3a\u65b9\u9635\u624d\u53ef\u4ee5\u8fdb\u884cQR\u5206\u89e3");
    }
}

