/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.naturalLanguage;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.config.TfConfig;
import org.dromara.easyai.entity.TalkBody;
import org.dromara.easyai.naturalLanguage.word.WordBack;
import org.dromara.easyai.transFormer.TransFormerManager;
import org.dromara.easyai.transFormer.TransWordVector;
import org.dromara.easyai.transFormer.model.TransFormerModel;
import org.dromara.easyai.transFormer.nerve.SensoryNerve;

public class TalkToTalk {
    private final TfConfig tfConfig;
    private final int maxLength;
    private final int times;
    private final TransFormerManager transFormerManager = new TransFormerManager();
    private final boolean splitAnswer;
    private final String splitWord;

    public TalkToTalk(TfConfig tfConfig) throws Exception {
        this.splitWord = tfConfig.getSplitWord();
        this.splitAnswer = this.splitWord != null && !this.splitWord.isEmpty();
        this.tfConfig = tfConfig;
        this.maxLength = tfConfig.getMaxLength();
        this.times = tfConfig.getTimes();
        if (this.times <= 0) {
            throw new Exception("\u53c2\u6570times\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    private void init(List<TalkBody> talkBodies) throws Exception {
        ArrayList<String> sentenceList = new ArrayList<String>();
        for (TalkBody talkBody : talkBodies) {
            sentenceList.add(talkBody.getQuestion());
            sentenceList.add(talkBody.getAnswer());
        }
        this.transFormerManager.init(this.tfConfig, sentenceList);
    }

    public String getAnswer(String question, long eventID) throws Exception {
        int id;
        SensoryNerve sensoryNerve = this.transFormerManager.getSensoryNerve();
        TransWordVector transWordVector = this.transFormerManager.getTransWordVector();
        int end = transWordVector.getEndID();
        WordBack wordBack = new WordBack();
        StringBuilder answer = new StringBuilder();
        int index = 0;
        do {
            String myAnswer = null;
            if (answer.length() > 0) {
                myAnswer = answer.toString();
            }
            sensoryNerve.postSentence(eventID, question, myAnswer, false, wordBack);
            id = wordBack.getId();
            if (id == end) continue;
            String word = transWordVector.getWordByID(id);
            if (this.splitAnswer) {
                answer.append(this.splitWord).append(word);
                continue;
            }
            answer.append(word);
        } while (id != end && ++index < this.maxLength);
        String result = answer.toString();
        return result.replace(this.tfConfig.startWord, "");
    }

    public void insertModel(TransFormerModel transFormerModel) throws Exception {
        this.transFormerManager.insertModel(transFormerModel, this.tfConfig);
    }

    public TransFormerModel study(List<TalkBody> talkBodies) throws Exception {
        this.init(talkBodies);
        SensoryNerve sensoryNerve = this.transFormerManager.getSensoryNerve();
        int size = talkBodies.size();
        for (int k = 0; k < this.times; ++k) {
            int index = 0;
            for (TalkBody talkBody : talkBodies) {
                String question = talkBody.getQuestion();
                String answer = talkBody.getAnswer();
                System.out.println("\u95ee\u9898:" + question + ", \u56de\u7b54:" + answer + ",\u8bad\u7ec3\u8bed\u53e5\u4e0b\u6807:" + ++index + ",\u603b\u6570\u91cf:" + size + ",\u5f53\u524d\u6b21\u6570\uff1a" + k + ",\u603b\u6b21\u6570:" + this.times);
                sensoryNerve.postSentence(1L, question, answer, true, null);
            }
        }
        return this.transFormerManager.getModel();
    }
}

