/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.naturalLanguage;

import java.util.ArrayList;
import java.util.List;
import org.dromara.easyai.naturalLanguage.KeyWord;
import org.dromara.easyai.naturalLanguage.Sentence;
import org.dromara.easyai.naturalLanguage.Word;
import org.dromara.easyai.naturalLanguage.WordTemple;
import org.dromara.easyai.naturalLanguage.WorldBody;
import org.dromara.easyai.tools.ArithUtil;
import org.dromara.easyai.tools.Frequency;

public class Tokenizer
extends Frequency {
    private final List<Sentence> sentences;
    private final List<WorldBody> allWorld;
    private final float wordNoise;

    public Tokenizer(WordTemple wordTemple) {
        this.sentences = wordTemple.getSentences();
        this.allWorld = wordTemple.getAllWorld();
        this.wordNoise = wordTemple.getWordNoise();
    }

    public void start(List<String> st) throws Exception {
        for (String sentence : st) {
            Sentence sentenceWords = new Sentence();
            this.catchSentence(sentence, sentenceWords);
            Word word = sentenceWords.getFirstWord();
            if (word == null) continue;
            this.worldMuch(word, this.allWorld);
        }
        this.restructure();
    }

    private void restructure() {
        for (Sentence words : this.sentences) {
            List<WorldBody> listWord = this.allWorld;
            List<Word> waitWorld = words.getWaitWords();
            for (Word word : waitWorld) {
                String myWord = word.getWord();
                WorldBody body = this.getBody(myWord, listWord);
                listWord = body.getWorldBodies();
                word.setWordFrequency(body.getWordFrequency());
            }
        }
        for (Sentence words : this.sentences) {
            this.radiation(words);
        }
    }

    public void radiation(Sentence sentenceWords) {
        Word nowWord = null;
        Word firstWord = sentenceWords.getFirstWord();
        KeyWord word = new KeyWord();
        word.setWord(firstWord);
        word.setOk(false);
        ArrayList<String> keyWords = new ArrayList<String>();
        while (word.getWord() != null) {
            word = this.keyWord(-1.0f, word, new float[]{firstWord.getWordFrequency()});
            Word myWord = word.getWord();
            String wordT = myWord.getWord();
            String keyWord = nowWord == null ? wordT : wordT.substring(nowWord.getWord().length());
            keyWords.add(keyWord);
            nowWord = myWord;
            word.setOk(false);
            word.setWord(word.getWord().getSon());
        }
        sentenceWords.setKeyWords(keyWords);
    }

    private float[] getDiff(float[] diff, Word word) {
        float[] diffef = new float[diff.length + 1];
        for (int i = 0; i < diffef.length; ++i) {
            diffef[i] = i == diffef.length - 1 ? (float)word.getWordFrequency() : diff[i];
        }
        return diffef;
    }

    private KeyWord keyWord(float dm, KeyWord words, float[] diff) {
        float right = 0.0f;
        boolean bm = words.isOk();
        if (!bm) {
            Word word = words.getWord();
            if (word.getSon() != null) {
                boolean isAvgOk;
                float db = this.wordEnd(word, new ArrayList<Integer>(), 0.0f);
                boolean bl = isAvgOk = ArithUtil.mul(word.getWordFrequency() - word.getSon().getWordFrequency(), this.wordNoise) <= db;
                if (isAvgOk) {
                    diff = this.getDiff(diff, word.getSon());
                    right = this.dc(diff);
                    if (dm > -1.0f) {
                        if (ArithUtil.mul(right, this.wordNoise) <= dm) {
                            words.setOk(false);
                            words.setWord(word.getSon());
                            words = this.keyWord(right, words, diff);
                        } else {
                            words.setOk(true);
                        }
                    } else {
                        words.setOk(false);
                        words.setWord(word.getSon());
                        words = this.keyWord(right, words, diff);
                    }
                } else {
                    words.setOk(true);
                }
            } else {
                words.setOk(true);
            }
        }
        return words;
    }

    private float wordEnd(Word word, List<Integer> av, float a) {
        Word son = word.getSon();
        if (son != null) {
            av.add(word.getWordFrequency() - son.getWordFrequency());
            a = this.wordEnd(son, av, a);
        } else {
            float[] allNub = new float[av.size()];
            for (int i = 0; i < av.size(); ++i) {
                allNub[i] = av.get(i).intValue();
            }
            a = this.average(allNub);
        }
        return a;
    }

    private WorldBody getBody(String word, List<WorldBody> worlds) {
        WorldBody myBody = null;
        for (WorldBody body : worlds) {
            if (body.getWordName().hashCode() != word.hashCode() || !body.getWordName().equals(word)) continue;
            myBody = body;
            break;
        }
        return myBody;
    }

    private void catchSentence(String sentence, Sentence sentenceWords) {
        int len = sentence.length();
        for (int i = 0; i < len; ++i) {
            String word = sentence.substring(0, i + 1);
            sentenceWords.setWord(word);
        }
        this.sentences.add(sentenceWords);
    }

    private void worldMuch(Word word, List<WorldBody> worldBodies) {
        boolean bm = false;
        String check = word.getWord();
        for (WorldBody myWorld : worldBodies) {
            String waitCheck = myWorld.getWordName();
            if (waitCheck.hashCode() != check.hashCode() || !waitCheck.equals(check)) continue;
            bm = true;
            myWorld.addNub();
            if (word.getSon() == null) break;
            this.worldMuch(word.getSon(), myWorld.getWorldBodies());
            break;
        }
        if (!bm) {
            this.saveList(word, worldBodies);
        }
    }

    private void saveList(Word word, List<WorldBody> myWorld) {
        WorldBody body = new WorldBody();
        ArrayList<WorldBody> list = new ArrayList<WorldBody>();
        body.setWordName(word.getWord());
        body.addNub();
        body.setWorldBodies(list);
        body.setWord(word);
        myWorld.add(body);
        if (word.getSon() != null) {
            this.saveList(word.getSon(), list);
        }
    }
}

