/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.naturalLanguage.word;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.easyai.config.SentenceConfig;
import org.dromara.easyai.entity.KeyWordForSentence;
import org.dromara.easyai.entity.WordBack;
import org.dromara.easyai.function.Tanh;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;
import org.dromara.easyai.naturalLanguage.word.WordEmbedding;
import org.dromara.easyai.rnnNerveCenter.ModelParameter;
import org.dromara.easyai.rnnNerveCenter.NerveManager;
import org.dromara.easyai.rnnNerveEntity.SensoryNerve;

public class MyKeyWord
extends MatrixOperation {
    private final WordEmbedding wordEmbedding;
    private final NerveManager typeNerveManager;
    private final int nerveLength;
    private final int maxWordLength;

    public MyKeyWord(SentenceConfig config, WordEmbedding wordEmbedding) throws Exception {
        int vectorDimension = config.getWordVectorDimension();
        int nerveLength = config.getKeyWordNerveDeep();
        float studyPoint = config.getWeStudyPoint();
        boolean isShowLog = config.isShowLog();
        this.maxWordLength = config.getMaxWordLength();
        this.typeNerveManager = new NerveManager(vectorDimension, vectorDimension, 2, nerveLength - 1, new Tanh(), studyPoint, 1, 1.0E-4f);
        this.typeNerveManager.initRnn(true, isShowLog);
        this.wordEmbedding = wordEmbedding;
        this.nerveLength = nerveLength;
    }

    public ModelParameter study(List<KeyWordForSentence> keyWordForSentenceList) throws Exception {
        for (KeyWordForSentence keyWordForSentence : keyWordForSentenceList) {
            String word = keyWordForSentence.getSentence();
            String keyWord = keyWordForSentence.getKeyWord();
            this.myStudy(true, 1L, word, keyWord, new HashMap<Integer, Float>());
        }
        return this.typeNerveManager.getModelParameter();
    }

    public void insertModel(ModelParameter modelParameter) throws Exception {
        this.typeNerveManager.insertModelParameter(modelParameter);
    }

    public boolean isKeyWord(String word, long eventId) throws Exception {
        boolean isKeyWord = false;
        int key = this.myStudy(false, eventId, word, null, null);
        if (key == 1) {
            isKeyWord = true;
        }
        return isKeyWord;
    }

    private int myStudy(boolean isStudy, long eventId, String word, String keyWord, Map<Integer, Float> E) throws Exception {
        int key = 0;
        if (word.length() > 1) {
            if (word.length() > this.maxWordLength) {
                word = word.substring(0, this.maxWordLength);
            }
            WordBack wordBack = null;
            int startIndex = -1;
            int endIndex = -1;
            if (!isStudy) {
                wordBack = new WordBack();
            } else if (keyWord != null && !keyWord.isEmpty()) {
                startIndex = word.indexOf(keyWord);
                endIndex = startIndex + keyWord.length() - 1;
            }
            int times = 1;
            if (this.nerveLength < word.length()) {
                times = word.length() - this.nerveLength + 1;
            }
            Matrix allFeature = this.wordEmbedding.getEmbedding(word, eventId, false).getFeatureMatrix();
            for (int i = 0; i < times; ++i) {
                if (isStudy) {
                    E.clear();
                    if (i > endIndex || i + this.nerveLength - 1 < startIndex) {
                        E.put(2, Float.valueOf(1.0f));
                    } else {
                        E.put(1, Float.valueOf(1.0f));
                    }
                } else {
                    wordBack.clear();
                }
                Matrix feature = times == 1 ? allFeature : allFeature.getSonOfMatrix(i, 0, this.nerveLength, allFeature.getY());
                List<Float> firstFeature = this.rowVectorToList(feature.getRow(0));
                this.studyNerve(eventId, this.typeNerveManager.getSensoryNerves(), firstFeature, feature, E, isStudy, wordBack);
                if (!isStudy && (key = wordBack.getId()) == 1) break;
            }
        }
        return key;
    }

    private void studyNerve(long eventId, List<SensoryNerve> sensoryNerves, List<Float> featureList, Matrix rnnMatrix, Map<Integer, Float> E, boolean isStudy, OutBack convBack) throws Exception {
        if (sensoryNerves.size() == featureList.size()) {
            for (int i = 0; i < sensoryNerves.size(); ++i) {
                sensoryNerves.get(i).postMessage(eventId, featureList.get(i).floatValue(), isStudy, E, convBack, false, rnnMatrix);
            }
        } else {
            throw new Exception("size not equals,feature size:" + featureList.size() + ",sensorySize:" + sensoryNerves.size());
        }
    }
}

