/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.nerveEntity;

import java.util.Map;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.nerveEntity.Nerve;

public class OutNerve
extends Nerve {
    private final boolean isShowLog;
    private final boolean isSoftMax;

    public OutNerve(int id, int upNub, int downNub, float studyPoint, boolean init, ActiveFunction activeFunction, boolean isDynamic, boolean isShowLog, int rzType, float lParam, boolean isSoftMax, int kernLen, int coreNumber) throws Exception {
        super(id, upNub, "OutNerve", downNub, studyPoint, init, activeFunction, isDynamic, rzType, lParam, kernLen, 0, 0, 0, coreNumber, 0, 0.0f, false);
        this.isShowLog = isShowLog;
        this.isSoftMax = isSoftMax;
    }

    void getGBySoftMax(float g, long eventId) throws Exception {
        this.gradient = g;
        this.updatePower(eventId);
    }

    @Override
    public void input(long eventId, float parameter, boolean isStudy, Map<Integer, Float> E, OutBack outBack) throws Exception {
        boolean allReady = this.insertParameter(eventId, parameter);
        if (allReady) {
            float sigma = this.calculation(eventId);
            if (this.isSoftMax) {
                if (!isStudy) {
                    this.destoryParameter(eventId);
                }
                this.sendMessage(eventId, sigma, isStudy, E, outBack);
            } else {
                float out = this.activeFunction.function(sigma);
                if (isStudy) {
                    this.outNub = out;
                    this.E = E.containsKey(this.getId()) ? E.get(this.getId()).floatValue() : -1.0f;
                    if (this.isShowLog) {
                        System.out.println("E==" + this.E + ",out==" + out + ",nerveId==" + this.getId());
                    }
                    this.gradient = this.outGradient();
                    this.updatePower(eventId);
                } else {
                    this.destoryParameter(eventId);
                    if (outBack != null) {
                        outBack.getBack(out, this.getId(), eventId);
                    } else {
                        throw new Exception("not find outBack");
                    }
                }
            }
        }
    }

    private float outGradient() {
        return this.activeFunction.functionG(this.outNub) * (this.E - this.outNub);
    }
}

