/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.recommend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dromara.easyai.function.Tanh;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.recommend.CodeBack;
import org.dromara.easyai.recommend.CodeBody;
import org.dromara.easyai.recommend.RecommendConfig;
import org.dromara.easyai.rnnNerveCenter.NerveManager;
import org.dromara.easyai.rnnNerveEntity.SensoryNerve;
import org.dromara.easyai.tools.IdCreator;

public class RecommendCodeManager {
    private final NerveManager nerveManager;
    private final float studyTh;
    private final int dim;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RecommendCodeManager(boolean initPower, RecommendConfig recommendConfig) throws Exception {
        this.studyTh = recommendConfig.getStudyTh();
        this.dim = recommendConfig.getDimension();
        this.nerveManager = new NerveManager(31, this.dim, 31, 1, new Tanh(), 0.01f, 1, 1.0E-4f);
        this.nerveManager.setSoftMax(false);
        this.nerveManager.initRnn(initPower, false);
    }

    public float[] getFeatures(int feature) {
        float[] features = new float[31];
        for (int i = 0; i < 31; ++i) {
            int t = 1 << i;
            if ((feature & t) == 0) continue;
            features[i] = 1.0f;
        }
        return features;
    }

    public Map<Integer, Float> getMap(float[] feature) {
        HashMap<Integer, Float> map = new HashMap<Integer, Float>();
        for (int i = 0; i < feature.length; ++i) {
            int t = i + 1;
            map.put(t, Float.valueOf(feature[i]));
        }
        return map;
    }

    private Matrix getSubMatrix(float sub) throws Exception {
        Matrix subMatrix = new Matrix(2, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            subMatrix.setNub(1, i, sub);
        }
        return subMatrix;
    }

    public void study(List<CodeBody> codeBodyList) throws Exception {
        for (int i = 0; i < codeBodyList.size(); ++i) {
            CodeBody myCodeBody = codeBodyList.get(i);
            float myPower = myCodeBody.getPower();
            if (!(myPower >= this.studyTh)) continue;
            float[] myId = this.getFeatures(myCodeBody.getId());
            Map<Integer, Float> myMapId = this.getMap(myId);
            for (int j = 0; j < codeBodyList.size(); ++j) {
                if (i == j) continue;
                CodeBody codeBody = codeBodyList.get(j);
                Matrix sub = this.getSubMatrix((myPower - codeBody.getPower()) / (float)this.dim);
                float[] id = this.getFeatures(codeBody.getId());
                Map<Integer, Float> mapId = this.getMap(id);
                this.lock.writeLock().lock();
                this.studyNerve(1L, myId, sub, mapId, true, null);
                this.studyNerve(1L, id, sub, myMapId, true, null);
                this.lock.writeLock().unlock();
            }
        }
    }

    public float[] getMappingId(int id) throws Exception {
        this.lock.readLock().lock();
        CodeBack codeBack = new CodeBack();
        codeBack.setMyFeature(new float[31]);
        Matrix subMatrix = new Matrix(2, this.dim);
        long nextId = IdCreator.get().nextId();
        float[] feature = this.getFeatures(id);
        this.studyNerve(nextId, feature, subMatrix, null, false, codeBack);
        this.lock.readLock().unlock();
        return codeBack.getMyFeature();
    }

    private void studyNerve(long eventId, float[] features, Matrix rnnMatrix, Map<Integer, Float> E, boolean isStudy, OutBack convBack) throws Exception {
        List<SensoryNerve> sensoryNerves = this.nerveManager.getSensoryNerves();
        if (sensoryNerves.size() == features.length) {
            for (int i = 0; i < sensoryNerves.size(); ++i) {
                sensoryNerves.get(i).postMessage(eventId, features[i], isStudy, E, convBack, false, rnnMatrix);
            }
        } else {
            throw new Exception("size not equals,feature size:" + features.length + ",sensorySize:" + sensoryNerves.size());
        }
    }
}

