/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnJumpNerveCenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.easyai.config.SentenceConfig;
import org.dromara.easyai.entity.CreatorModel;
import org.dromara.easyai.entity.SemanticsBack;
import org.dromara.easyai.entity.TalkBody;
import org.dromara.easyai.function.Tanh;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.naturalLanguage.word.WordEmbedding;
import org.dromara.easyai.rnnJumpNerveCenter.NerveJumpManager;
import org.dromara.easyai.rnnJumpNerveEntity.MyWordFeature;
import org.dromara.easyai.rnnJumpNerveEntity.NerveCenter;
import org.dromara.easyai.rnnJumpNerveEntity.SensoryNerve;

@Deprecated
public class CustomManager {
    private final WordEmbedding wordEmbedding;
    private NerveJumpManager semanticsManager;
    private final int vectorDimension;
    private final int maxFeatureLength;
    private final float studyPoint;
    private final int minLength;
    private final int answerMaxLength;
    private int times;
    private final float param;
    private final float powerTh;
    private final int rzModel;

    public CustomManager(WordEmbedding wordEmbedding, SentenceConfig config) {
        this.minLength = config.getMinLength();
        this.wordEmbedding = wordEmbedding;
        this.vectorDimension = config.getQaWordVectorDimension();
        this.maxFeatureLength = config.getMaxWordLength();
        this.studyPoint = config.getWeStudyPoint();
        this.answerMaxLength = config.getMaxAnswerLength();
        this.powerTh = config.getSentenceTrustPowerTh();
        this.times = config.getTimes();
        this.param = config.getParam();
        this.rzModel = config.getRzModel();
        if (this.times < 1) {
            this.times = 1;
        }
    }

    public void init() throws Exception {
        this.semanticsManager = new NerveJumpManager(this.vectorDimension, this.vectorDimension, this.wordEmbedding.getWordList().size(), this.maxFeatureLength + this.answerMaxLength - 1, new Tanh(), false, this.studyPoint, this.rzModel, this.param);
        this.semanticsManager.setPowerTh(this.powerTh);
        this.semanticsManager.initRnn(true, true, true, true, this.maxFeatureLength);
        List<NerveCenter> nerveCenterList = this.semanticsManager.getNerveCenterList();
        for (NerveCenter nerveCenter : nerveCenterList) {
            nerveCenter.setWordEmbedding(this.wordEmbedding);
        }
    }

    public void insertModel(CreatorModel creatorModel) throws Exception {
        this.semanticsManager.insertModelParameter(creatorModel.getSemanticsModel());
    }

    public String getAnswer(String question, long eventID) throws Exception {
        SemanticsBack semanticsBack = new SemanticsBack();
        if (question.length() > this.maxFeatureLength) {
            question = question.substring(0, this.maxFeatureLength);
        }
        MyWordFeature myWordFeature = this.wordEmbedding.getEmbedding(question, eventID, false);
        List<Float> featureList = myWordFeature.getFirstFeatureList();
        Matrix featureMatrix = myWordFeature.getFeatureMatrix();
        featureMatrix = this.insertZero(featureMatrix, featureMatrix.getX());
        int[] storeys = this.getStoreys2(question.length(), this.maxFeatureLength);
        this.studySemanticsNerve(eventID, featureList, false, null, semanticsBack, featureMatrix, storeys, question.length());
        return semanticsBack.getWord();
    }

    public CreatorModel study(List<TalkBody> talkBodies) throws Exception {
        Random random = new Random();
        CreatorModel creatorModel = new CreatorModel();
        int maxTime = this.maxFeatureLength * this.answerMaxLength * this.times;
        int wordSize = talkBodies.size() * maxTime;
        int index = 0;
        for (int i = 0; i < maxTime; ++i) {
            System.out.println("\u751f\u6210\u6a21\u578b\u5b66\u4e60\u5b8c\u6210\u6b21\u6570\uff1a" + (i + 1) + "\u603b\u5171\u6b21\u6570:" + maxTime);
            for (TalkBody talkBody : talkBodies) {
                ++index;
                String question = talkBody.getQuestion();
                String answer = talkBody.getAnswer();
                if (question.length() > this.maxFeatureLength) {
                    question = question.substring(0, this.maxFeatureLength);
                }
                if (answer.length() > this.answerMaxLength) {
                    answer = answer.substring(0, this.answerMaxLength);
                }
                String word = question + answer;
                MyWordFeature myWordFeature = this.wordEmbedding.getEmbedding(word, 1L, false);
                this.semanticsStudy(myWordFeature, question, answer, 1L, random);
                float point = (float)index / (float)wordSize * 100.0f;
                String result = String.format("%.6f", Float.valueOf(point));
                System.out.println("\u8bad\u7ec3\u8fdb\u5ea6\uff1a" + result + "%");
            }
        }
        creatorModel.setSemanticsModel(this.semanticsManager.getModelParameter());
        return creatorModel;
    }

    private int[] getStoreys2(int len, int finishIndex) {
        int[] storeys = new int[len + 1];
        for (int i = 0; i < storeys.length; ++i) {
            storeys[i] = i < storeys.length - 1 ? i : finishIndex;
        }
        return storeys;
    }

    private int[] getStoreys(int len, Random random, int startIndex) {
        int[] storeys;
        if (len < this.minLength) {
            storeys = new int[len];
            for (int i = 0; i < len; ++i) {
                storeys[i] = i + startIndex;
            }
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 1; i < len; ++i) {
                list.add(i);
            }
            int myLen = (int)((float)this.minLength + (float)Math.random() * (float)(len - this.minLength + 1));
            storeys = new int[myLen];
            if (startIndex > 0) {
                storeys[0] = startIndex;
            }
            for (int i = 1; i < myLen; ++i) {
                int index = random.nextInt(list.size());
                storeys[i] = (Integer)list.get(index) + startIndex;
                list.remove(index);
            }
            Arrays.sort(storeys);
        }
        return storeys;
    }

    private int[] pushArray(int[] arr, int value) {
        int[] myArr = new int[arr.length + 1];
        for (int i = 0; i < myArr.length; ++i) {
            myArr[i] = i < myArr.length - 1 ? arr[i] : value;
        }
        return myArr;
    }

    private Matrix insertZero(Matrix feature, int index) throws Exception {
        Matrix matrix = new Matrix(feature.getX() + 1, feature.getY());
        int x = matrix.getX();
        int y = matrix.getY();
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                if (i < index) {
                    matrix.setNub(i, j, feature.getNumber(i, j));
                    continue;
                }
                if (i <= index) continue;
                matrix.setNub(i, j, feature.getNumber(i - 1, j));
            }
        }
        return matrix;
    }

    private void semanticsStudy(MyWordFeature myWordFeature, String question, String answer, long eventID, Random random) throws Exception {
        Matrix featureMatrix = this.insertZero(myWordFeature.getFeatureMatrix(), question.length());
        List<Float> firstFeatureList = myWordFeature.getFirstFeatureList();
        System.out.println("\u8bad\u7ec3question:" + question + ",answer:" + answer);
        if (question.length() > 1 && !answer.isEmpty()) {
            int[] questionStoreys = this.getStoreys(question.length(), random, 0);
            int[] answerStoreys = this.getStoreys(answer.length() + 1, random, this.maxFeatureLength);
            HashMap<Integer, Float> E = new HashMap<Integer, Float>();
            for (int i = 0; i < answerStoreys.length - 1; ++i) {
                E.clear();
                int index = answerStoreys[i + 1] - this.maxFeatureLength;
                questionStoreys = this.pushArray(questionStoreys, answerStoreys[i]);
                String myAnswer = answer.substring(index - 1, index);
                int wordID = this.wordEmbedding.getID(myAnswer) + 1;
                E.put(wordID, Float.valueOf(1.0f));
                this.studySemanticsNerve(eventID, firstFeatureList, true, E, null, featureMatrix, questionStoreys, question.length());
            }
        }
    }

    private void studySemanticsNerve(long eventId, List<Float> featureList, boolean isStudy, Map<Integer, Float> E, SemanticsBack semanticsBack, Matrix rnnMatrix, int[] storeys, int questionLength) throws Exception {
        List<SensoryNerve> sensoryNerves = this.semanticsManager.getSensoryNerves();
        if (sensoryNerves.size() == featureList.size()) {
            for (int i = 0; i < sensoryNerves.size(); ++i) {
                sensoryNerves.get(i).postMessage(eventId, featureList.get(i).floatValue(), isStudy, E, semanticsBack, rnnMatrix, storeys, questionLength);
            }
        } else {
            throw new Exception("1size not equals,feature size:" + featureList.size() + ",sensorySize:" + sensoryNerves.size());
        }
    }
}

