/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.rnnJumpNerveEntity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dromara.easyai.i.ActiveFunction;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;

public abstract class Nerve {
    private final Map<Integer, List<Nerve>> son = new HashMap<Integer, List<Nerve>>();
    private final Map<Integer, List<Nerve>> father = new HashMap<Integer, List<Nerve>>();
    private final List<Nerve> rnnOut = new ArrayList<Nerve>();
    protected Map<Integer, Float> dendrites = new HashMap<Integer, Float>();
    protected Map<Integer, Float> wg = new HashMap<Integer, Float>();
    private final int id;
    boolean fromOutNerve = false;
    private final int hiddenNerveNub;
    private final int sensoryNerveNub;
    private final int outNerveNub;
    protected Map<Long, List<Float>> features = new HashMap<Long, List<Float>>();
    protected Matrix nerveMatrix;
    protected float threshold;
    protected String name;
    protected float outNub;
    protected float E;
    protected float gradient;
    protected float studyPoint;
    protected float sigmaW;
    private int backNub = 0;
    protected ActiveFunction activeFunction;
    private final int rzType;
    private final float lParam;
    private int myUpNumber;
    protected int depth;
    protected int allDepth;
    protected boolean creator;
    protected int startDepth;

    public int getDepth() {
        return this.depth;
    }

    public Map<Integer, Float> getDendrites() {
        return this.dendrites;
    }

    public Matrix getNerveMatrix() {
        return this.nerveMatrix;
    }

    public void setNerveMatrix(Matrix nerveMatrix) {
        this.nerveMatrix = nerveMatrix;
    }

    public void setDendrites(Map<Integer, Float> dendrites) {
        this.dendrites = dendrites;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    protected Nerve(int id, String name, float studyPoint, boolean init, ActiveFunction activeFunction, int rzType, float lParam, int sensoryNerveNub, int hiddenNerveNub, int outNerveNub, int allDepth, boolean creator, int startDepth) throws Exception {
        this.id = id;
        this.creator = creator;
        this.startDepth = startDepth;
        this.allDepth = allDepth;
        this.hiddenNerveNub = hiddenNerveNub;
        this.sensoryNerveNub = sensoryNerveNub;
        this.outNerveNub = outNerveNub;
        this.name = name;
        this.studyPoint = studyPoint;
        this.activeFunction = activeFunction;
        this.rzType = rzType;
        this.lParam = lParam;
        if (name.equals("OutNerve")) {
            this.fromOutNerve = true;
        }
        this.initPower(init);
    }

    protected void setStudyPoint(float studyPoint) {
        this.studyPoint = studyPoint;
    }

    private int getNextStorey(int[] storeys, int index) {
        int nextStorey = -1;
        int nextIndex = index + 1;
        if (storeys.length > nextIndex) {
            nextStorey = storeys[nextIndex];
        }
        return nextStorey;
    }

    protected void sendSoftMaxBack(long eventId, float parameter, Matrix rnnMatrix, OutBack outBack, String myWord) throws Exception {
        if (!this.son.isEmpty()) {
            List<Nerve> nerverList = this.son.get(0);
            for (Nerve nerve : nerverList) {
                nerve.sendAppointSoftMax(eventId, parameter, rnnMatrix, outBack, myWord);
            }
        } else {
            throw new Exception("this storey is lastIndex");
        }
    }

    protected void sendSoftMax(long eventId, float parameter, boolean isStudy, Map<Integer, Float> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index) throws Exception {
        if (!this.son.isEmpty()) {
            List<Nerve> nerverList = this.son.get(0);
            for (Nerve nerve : nerverList) {
                nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, 0);
            }
        } else {
            throw new Exception("this storey is lastIndex");
        }
    }

    protected void clearData(long eventId) {
    }

    protected void sendMyTestMessage(long eventId, Matrix featureMatrix, OutBack outBack, String word) throws Exception {
    }

    protected void sendAppointSoftMax(long eventId, float parameter, Matrix rnnMatrix, OutBack outBack, String myWord) throws Exception {
    }

    protected void sendAppointTestMessage(long eventId, float parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendTestMessage(long eventId, float parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (this.son.isEmpty()) throw new Exception("this layer is lastIndex");
        List<Nerve> nerveList = this.son.get(this.depth + 1);
        if (nerveList == null) throw new Exception("Insufficient layer:" + this.depth + 1);
        for (Nerve nerve : nerveList) {
            nerve.sendAppointTestMessage(eventId, parameter, featureMatrix, outBack, myWord);
        }
    }

    protected void sendRnnTestMessage(long eventId, float parameter, Matrix featureMatrix, OutBack outBack, String myWord) throws Exception {
        if (!this.rnnOut.isEmpty()) {
            for (Nerve nerve : this.rnnOut) {
                nerve.sendAppointTestMessage(eventId, parameter, featureMatrix, outBack, myWord);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    protected void sendMessage(long eventId, float parameter, boolean isStudy, Map<Integer, Float> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
        List<Nerve> nerveList = null;
        int nextStorey = 0;
        if (storeys == null) {
            nerveList = this.son.get(0);
        } else {
            nextStorey = this.getNextStorey(storeys, index);
            if (nextStorey > -1) {
                nerveList = this.son.get(nextStorey);
                ++index;
                if (nerveList == null) {
                    throw new Exception("\u5411\u524d->\u8981\u67e5\u627e\u7684\u5c42\u6570\u4e0d\u5b58\u5728\u94fe\u63a5\uff0c\u5e8f\u5217\uff1a" + index + "\u5c42\u6570:" + nextStorey + ",\u5f53\u524d\u6240\u5728\u5c42\u6570:" + this.depth + ",\u6211\u7684\u8eab\u4efd:" + this.name);
                }
            }
        }
        if (nerveList != null) {
            if (this.creator && !isStudy && nextStorey == this.startDepth) {
                for (Nerve nerve : nerveList) {
                    nerve.sendAppointTestMessage(eventId, parameter, rnnMatrix, outBack, null);
                }
            } else {
                for (Nerve nerve : nerveList) {
                    nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, questionLength);
                }
            }
        } else {
            this.sendRnnMessage(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index);
        }
    }

    private void sendRnnMessage(long eventId, float parameter, boolean isStudy, Map<Integer, Float> E, OutBack outBack, Matrix rnnMatrix, int[] storeys, int index) throws Exception {
        if (!this.rnnOut.isEmpty()) {
            for (Nerve nerve : this.rnnOut) {
                nerve.input(eventId, parameter, isStudy, E, outBack, rnnMatrix, storeys, index, 0);
            }
        } else {
            throw new Exception("this layer is lastIndex");
        }
    }

    private void backSendMessage(long eventId, boolean fromOutNerve, int[] storeys, int index) throws Exception {
        if (!this.father.isEmpty()) {
            List<Nerve> nerveList = null;
            if (storeys == null) {
                nerveList = this.father.get(0);
            } else if (index > 0) {
                nerveList = this.father.get(storeys[index]);
                if (nerveList == null) {
                    throw new Exception("\u5411\u540e->\u8981\u67e5\u627e\u7684\u5c42\u6570\u4e0d\u5b58\u5728\u94fe\u63a5\uff0c\u5e8f\u5217\uff1a" + index + "\u76ee\u6807\u5c42\u6570:" + storeys[index] + ",\u5f53\u524d\u6240\u5728\u5c42\u6570:" + this.depth + ",\u6211\u7684\u8eab\u4efd:" + this.name);
                }
                --index;
            }
            if (nerveList != null) {
                for (int i = 0; i < nerveList.size(); ++i) {
                    nerveList.get(i).backGetMessage(this.wg.get(i + 1).floatValue(), eventId, fromOutNerve, storeys, index);
                }
            }
        }
    }

    protected void input(long eventId, float parameter, boolean isStudy, Map<Integer, Float> E, OutBack imageBack, Matrix rnnMatrix, int[] storeys, int index, int questionLength) throws Exception {
    }

    private void backGetMessage(float parameter, long eventId, boolean fromOutNerve, int[] storeys, int index) throws Exception {
        ++this.backNub;
        this.sigmaW += parameter;
        int number = fromOutNerve ? this.outNerveNub : this.hiddenNerveNub;
        if (this.backNub == number) {
            this.backNub = 0;
            this.gradient = this.activeFunction.functionG(this.outNub) * this.sigmaW;
            this.updatePower(eventId, storeys, index);
        }
    }

    protected void updatePower(long eventId, int[] storeys, int index) throws Exception {
        float h = this.gradient * this.studyPoint;
        this.threshold -= h;
        this.updateW(h, eventId);
        this.sigmaW = 0.0f;
        this.backSendMessage(eventId, this.fromOutNerve, storeys, index);
    }

    private float regularization(float w, float param) {
        float re = 0.0f;
        if (this.rzType != 0) {
            if (this.rzType == 2) {
                re = param * -w;
            } else if (this.rzType == 1) {
                if (w > 0.0f) {
                    re = -param;
                } else if (w < 0.0f) {
                    re = param;
                }
            }
        }
        return re;
    }

    private void updateW(float h, long eventId) {
        List<Float> list = this.features.get(eventId);
        float param = 0.0f;
        if (this.rzType != 0) {
            float sigma = 0.0f;
            for (Map.Entry<Integer, Float> entry : this.dendrites.entrySet()) {
                if (this.rzType == 2) {
                    sigma += (float)Math.pow(entry.getValue().floatValue(), 2.0);
                    continue;
                }
                sigma += Math.abs(entry.getValue().floatValue());
            }
            param = sigma * this.lParam * this.studyPoint;
        }
        for (Map.Entry<Integer, Float> entry : this.dendrites.entrySet()) {
            int key = entry.getKey();
            float w = entry.getValue().floatValue();
            float bn = list.get(key - 1).floatValue();
            float wp = bn * h;
            float dm = w * this.gradient;
            float regular = this.regularization(w, param);
            w += regular;
            this.wg.put(key, Float.valueOf(dm));
            this.dendrites.put(key, Float.valueOf(w += wp));
        }
        this.features.remove(eventId);
    }

    protected boolean insertParameter(long eventId, float parameter) throws Exception {
        List<Object> featuresList;
        boolean allReady = false;
        if (this.features.containsKey(eventId)) {
            featuresList = this.features.get(eventId);
        } else {
            featuresList = new ArrayList();
            this.features.put(eventId, featuresList);
        }
        featuresList.add(Float.valueOf(parameter));
        if (featuresList.size() == this.myUpNumber) {
            allReady = true;
        } else if (featuresList.size() > this.myUpNumber) {
            throw new Exception("\u63a5\u6536\u53c2\u6570\u6570\u91cf\u5f02\u5e38");
        }
        return allReady;
    }

    protected void destroyParameter(long eventId) {
        this.features.remove(eventId);
    }

    protected float calculation(long eventId) {
        float sigma = 0.0f;
        List<Float> featuresList = this.features.get(eventId);
        for (int i = 0; i < featuresList.size(); ++i) {
            float value = featuresList.get(i).floatValue();
            float w = this.dendrites.get(i + 1).floatValue();
            sigma = w * value + sigma;
        }
        return sigma - this.threshold;
    }

    private void initPower(boolean init) throws Exception {
        Random random = new Random();
        this.myUpNumber = this.name.equals("HiddenNerve") ? this.sensoryNerveNub : (this.name.equals("OutNerve") ? this.hiddenNerveNub : this.outNerveNub);
        if (this.myUpNumber > 0) {
            float sh = (float)Math.sqrt(this.myUpNumber);
            for (int i = 1; i < this.myUpNumber + 1; ++i) {
                float nub = 0.0f;
                if (init) {
                    nub = random.nextFloat() / sh;
                }
                this.dendrites.put(i, Float.valueOf(nub));
            }
            float nub = 0.0f;
            if (init) {
                nub = random.nextFloat() / sh;
            }
            this.threshold = nub;
        }
    }

    public int getId() {
        return this.id;
    }

    public void connect(int depth, List<Nerve> nerveList) {
        this.son.put(depth, nerveList);
    }

    public void connectOut(List<Nerve> nerveList) {
        this.rnnOut.addAll(nerveList);
    }

    public void connectFather(int depth, List<Nerve> nerveList) {
        this.father.put(depth, nerveList);
    }
}

