/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.regressionForest.LinearRegression;

public class FastPictureExcerpt {
    public String creatImageName(ThreeChannelMatrix threeChannelMatrix, int boxSize, int regionSize) throws Exception {
        String R = this.creatImageName(threeChannelMatrix.getMatrixR(), boxSize, regionSize);
        String G = this.creatImageName(threeChannelMatrix.getMatrixG(), boxSize, regionSize);
        String B = this.creatImageName(threeChannelMatrix.getMatrixB(), boxSize, regionSize);
        return R + G + B;
    }

    private String creatImageName(Matrix h, int boxSize, int regionSize) throws Exception {
        int iSize = 5;
        Matrix vector = new Matrix(1, 3);
        vector.setNub(0, 0, 1.0f);
        vector.setNub(0, 1, 0.0f);
        vector.setNub(0, 2, 0.0f);
        int xf = h.getX();
        int yf = h.getY();
        int xMO = xf % boxSize / 2;
        int yMO = yf % boxSize / 2;
        int xSize = xf / boxSize;
        int ySize = yf / boxSize;
        Matrix hr = h.getSonOfMatrix(xMO, yMO, xSize * boxSize, ySize * boxSize);
        int x = hr.getX();
        int y = hr.getY();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= x - xSize; i += xSize) {
            for (int j = 0; j <= y - ySize; j += ySize) {
                Matrix sonH = hr.getSonOfMatrix(i, j, xSize, ySize);
                String name = FastPictureExcerpt.getName(sonH, iSize, vector, regionSize);
                if (regionSize > 10 && regionSize <= 100) {
                    if (name.length() == 1) {
                        name = "0" + name;
                    }
                } else if (regionSize > 100 && regionSize <= 1000) {
                    if (name.length() == 1) {
                        name = "00" + name;
                    } else if (name.length() == 2) {
                        name = "0" + name;
                    }
                }
                stringBuilder.append(name);
            }
        }
        return stringBuilder.toString();
    }

    private static String getName(Matrix h, int iSize, Matrix vector, int regionSize) throws Exception {
        int x = h.getX();
        int y = h.getY();
        int size = x / iSize * (y / iSize);
        LinearRegression linearRegression = new LinearRegression(size);
        int cPoint = iSize / 2 + 1;
        float maxXSize = (float)x / (float)iSize;
        float maxYSize = (float)y / (float)iSize;
        float[] xy = new float[2];
        for (int i = 0; i <= x - iSize; i += iSize) {
            for (int j = 0; j <= y - iSize; j += iSize) {
                float value = h.getSonOfMatrix(i, j, iSize, iSize).getNumber(cPoint, cPoint);
                float px = (float)i / (float)iSize / maxXSize;
                float py = (float)j / (float)iSize / maxYSize;
                xy[0] = px;
                xy[1] = py;
                linearRegression.insertXY(xy, value);
            }
        }
        linearRegression.regression();
        float myCos = linearRegression.getCos(vector);
        float oneSize = 1.0f / (float)regionSize;
        int index = 0;
        float minSub = -1.0f;
        for (int i = 0; i < regionSize; ++i) {
            float cos = (float)Math.cos((float)Math.PI * oneSize * (float)i);
            float sub = Math.abs(cos - myCos);
            if (minSub != -1.0f && !(sub < minSub)) continue;
            minSub = sub;
            index = i;
        }
        return String.valueOf(index);
    }
}

