/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.util.List;
import org.dromara.easyai.tools.ArithUtil;

public abstract class Frequency {
    public float average(float ... m) {
        int len = m.length;
        float allNub = 0.0f;
        for (int i = 0; i < len; ++i) {
            allNub += m[i];
        }
        return allNub /= (float)len;
    }

    public static float getEDist(float[] x1, float[] x2) {
        float[] y = new float[x1.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x1[i] - x2[i];
        }
        float sigma = 0.0f;
        for (int i = 0; i < y.length; ++i) {
            sigma += (float)Math.pow(y[i], 2.0);
        }
        return (float)Math.sqrt(sigma);
    }

    public float averageByList(List<Float> m) {
        int len = m.size();
        float allNub = 0.0f;
        for (int i = 0; i < len; ++i) {
            allNub += m.get(i).floatValue();
        }
        allNub = ArithUtil.div(allNub, len);
        return allNub;
    }

    public float sigma(float ... m) {
        int len = m.length;
        float allNub = 0.0f;
        for (int i = 0; i < len; ++i) {
            allNub = ArithUtil.add(allNub, m[i]);
        }
        return allNub;
    }

    public float getPointLength(float x, float y, float i, float j) {
        return (float)Math.sqrt(ArithUtil.add((float)Math.pow(ArithUtil.sub(x, i), 2.0), (float)Math.pow(ArithUtil.sub(y, j), 2.0)));
    }

    public float variance(float ... m) {
        float ave = this.average(m);
        float allNub = 0.0f;
        for (int i = 0; i < m.length; ++i) {
            allNub += (float)Math.pow(m[i] - ave, 2.0);
        }
        return allNub / (float)m.length;
    }

    public float varianceByAve(float[] m, float ave) {
        float allNub = 0.0f;
        for (int i = 0; i < m.length; ++i) {
            allNub += (float)Math.pow(m[i] - ave, 2.0);
        }
        return allNub / (float)m.length;
    }

    public float sdByAvg(float[] m, float avg) {
        float var = this.varianceByAve(m, avg);
        return (float)Math.sqrt(var);
    }

    public float sd(float ... m) {
        float var = this.variance(m);
        return (float)Math.sqrt(var);
    }

    public float dcByAvg(float[] m, float ave) {
        float allNub = 0.0f;
        for (int i = 0; i < m.length; ++i) {
            allNub += (float)Math.pow(m[i] - ave, 2.0);
        }
        return ArithUtil.div((float)Math.sqrt(ArithUtil.div(allNub, m.length)), ave);
    }

    public float dc(float ... m) {
        float ave = this.average(m);
        float dc = 0.0f;
        if (ave > 0.0f) {
            float allNub = 0.0f;
            for (int i = 0; i < m.length; ++i) {
                allNub += (float)Math.pow(m[i] - ave, 2.0);
            }
            dc = ArithUtil.div((float)Math.sqrt(ArithUtil.div(allNub, m.length)), ave);
        }
        return dc;
    }

    public float softMax(int t, float ... m) {
        float my = (float)Math.exp(m[t]);
        float all = 0.0f;
        int allLength = m.length;
        for (int i = 0; i < allLength; ++i) {
            all += (float)Math.exp(m[i]);
        }
        return ArithUtil.div(my, all);
    }

    public float[] getLimit(float[] m) {
        float[] limit = new float[2];
        float max = 0.0f;
        float min = -1.0f;
        for (float nub : m) {
            if (min == -1.0f || nub < min) {
                min = nub;
            }
            if (!(nub > max)) continue;
            max = nub;
        }
        limit[0] = min;
        limit[1] = max;
        return limit;
    }
}

