/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import org.dromara.easyai.entity.RGBNorm;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.tools.MeanClustering;

public class GMClustering
extends MeanClustering {
    private float regionSize;

    public float getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(float regionSize) {
        this.regionSize = regionSize;
    }

    public GMClustering(int speciesQuantity, int maxTimes) throws Exception {
        super(speciesQuantity, maxTimes);
    }

    public int getProbabilityDensity(float[] feature) throws Exception {
        float maxPower = 0.0f;
        int id = 0;
        int index = 0;
        for (RGBNorm rgbNorm : this.matrices) {
            float power = rgbNorm.getGMProbability(feature);
            if (power > maxPower) {
                maxPower = power;
                id = index;
            }
            ++index;
        }
        return id;
    }

    @Override
    public void start() throws Exception {
        super.start();
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.gm();
        }
        for (int i = 0; i < 50; ++i) {
            this.gmClustering();
        }
    }

    public void insertParameter(Matrix matrix) throws Exception {
        int y = matrix.getY();
        int size = y / this.speciesQuantity;
        for (int i = 0; i <= y - size; i += size) {
            float[] feature = new float[size];
            RGBNorm rgbNorm = new RGBNorm();
            this.matrices.add(rgbNorm);
            for (int j = i; j < i + size; ++j) {
                feature[j - i] = matrix.getNumber(0, j);
            }
            rgbNorm.insertFeature(feature);
        }
    }

    private void clear() {
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.clearRGB();
        }
    }

    private void gmClustering() throws Exception {
        this.clear();
        for (float[] rgb : this.matrixList) {
            int i;
            float allProbability = 0.0f;
            float[] pro = new float[this.speciesQuantity];
            for (i = 0; i < this.speciesQuantity; ++i) {
                RGBNorm rgbNorm = (RGBNorm)this.matrices.get(i);
                float probability = rgbNorm.getGMProbability(rgb);
                allProbability += probability;
                pro[i] = probability;
            }
            for (i = 0; i < this.speciesQuantity; ++i) {
                pro[i] = pro[i] / allProbability;
            }
            int index = 0;
            float max = 0.0f;
            for (int i2 = 0; i2 < this.speciesQuantity; ++i2) {
                if (!(pro[i2] > max)) continue;
                max = pro[i2];
                index = i2;
            }
            ((RGBNorm)this.matrices.get(index)).setGmFeature(rgb, pro[index]);
        }
        for (RGBNorm rgbNorm : this.matrices) {
            rgbNorm.gm();
        }
    }
}

