/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dromara.easyai.entity.ThreeChannelMatrix;
import org.dromara.easyai.matrixTools.Matrix;

public class Picture {
    public static ThreeChannelMatrix getMyPicture(int x, int y) throws Exception {
        Matrix matrixR = new Matrix(x, y);
        Matrix matrixG = new Matrix(x, y);
        Matrix matrixB = new Matrix(x, y);
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        threeChannelMatrix.setX(x);
        threeChannelMatrix.setY(y);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                matrixR.setNub(i, j, 1.0f);
                matrixG.setNub(i, j, 1.0f);
                matrixB.setNub(i, j, 1.0f);
            }
        }
        return threeChannelMatrix;
    }

    public static Matrix getImageMatrixByLocal(String fileURL) throws Exception {
        File file = new File(fileURL);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getImage(bi);
    }

    public static Matrix getImageMatrixByFile(File file) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getImage(bi);
    }

    public static ThreeChannelMatrix getThreeMatrix(File file, boolean vertical) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getThreeChannel(bi, vertical);
    }

    public static ThreeChannelMatrix getThreeMatrix(InputStream file, boolean vertical) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getThreeChannel(bi, vertical);
    }

    public static ThreeChannelMatrix getThreeMatrix(String fileURL, boolean vertical) throws Exception {
        File file = new File(fileURL);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getThreeChannel(bi, vertical);
    }

    public static Matrix getImageMatrixByIo(InputStream inputStream) throws Exception {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Picture.getImage(bi);
    }

    private static Matrix getImage(BufferedImage bi) throws Exception {
        int width = bi.getWidth();
        int height = bi.getHeight();
        Matrix matrix = new Matrix(height, width);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = bi.getRGB(j, i);
                float grab = Picture.dimensionReduction(pixel);
                matrix.setNub(i, j, grab);
            }
        }
        return matrix;
    }

    public static ThreeChannelMatrix getThreeChannel(BufferedImage bi, boolean vertical) throws Exception {
        int width = bi.getWidth();
        int height = bi.getHeight();
        boolean rotate = false;
        if (vertical && width > height) {
            rotate = true;
            width = bi.getHeight();
            height = bi.getWidth();
        }
        ThreeChannelMatrix threeChannelMatrix = new ThreeChannelMatrix();
        threeChannelMatrix.setX(height);
        threeChannelMatrix.setY(width);
        Matrix matrixR = new Matrix(height, width);
        Matrix matrixG = new Matrix(height, width);
        Matrix matrixB = new Matrix(height, width);
        Matrix matrixH = new Matrix(height, width);
        threeChannelMatrix.setMatrixR(matrixR);
        threeChannelMatrix.setMatrixG(matrixG);
        threeChannelMatrix.setMatrixB(matrixB);
        threeChannelMatrix.setH(matrixH);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = rotate ? bi.getRGB(i, j) : bi.getRGB(j, i);
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                matrixR.setNub(i, j, (float)r / 255.0f);
                matrixG.setNub(i, j, (float)g / 255.0f);
                matrixB.setNub(i, j, (float)b / 255.0f);
                matrixH.setNub(i, j, (float)(r * 38 + g * 75 + b * 15 >> 7) / 255.0f);
            }
        }
        return threeChannelMatrix;
    }

    private static float dimensionReduction(int pixel) {
        int r = (pixel & 0xFF0000) >> 16;
        int g = (pixel & 0xFF00) >> 8;
        int b = pixel & 0xFF;
        float gray = r * 38 + g * 75 + b * 15 >> 7;
        return gray;
    }
}

