/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.tools;

import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.matrixTools.MatrixOperation;

public class RgbRegression
extends MatrixOperation {
    private float wr;
    private float wg;
    private float b;
    private Matrix RG;
    private Matrix B;
    private Matrix RGB;
    private int xIndex = 0;
    private boolean isRegression = false;
    private int regionNub;
    private int x;
    private int y;

    public Matrix getRGB() {
        return this.RGB;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Matrix getRGMatrix() {
        return this.RG;
    }

    public Matrix getBMatrix() {
        return this.B;
    }

    public void clear(int size) {
        this.RG = new Matrix(size, 3);
        this.RGB = new Matrix(size, 3);
        this.B = new Matrix(size, 1);
        this.xIndex = 0;
        this.regionNub = size;
    }

    public int getRegionNub() {
        return this.regionNub;
    }

    public void setRegionNub(int regionNub) {
        this.regionNub = regionNub;
    }

    public float getWr() {
        return this.wr;
    }

    public float getWg() {
        return this.wg;
    }

    public float getB() {
        return this.b;
    }

    public RgbRegression(int size) {
        this.RG = new Matrix(size, 3);
        this.RGB = new Matrix(size, 3);
        this.B = new Matrix(size, 1);
        this.regionNub = size;
        this.xIndex = 0;
    }

    public void insertRGB(float[] rgb) throws Exception {
        if (rgb.length == 3) {
            this.RGB.setNub(this.xIndex, 0, rgb[0]);
            this.RGB.setNub(this.xIndex, 1, rgb[1]);
            this.RGB.setNub(this.xIndex, 2, rgb[2]);
            this.RG.setNub(this.xIndex, 0, rgb[0]);
            this.RG.setNub(this.xIndex, 1, rgb[1]);
            this.RG.setNub(this.xIndex, 2, 1.0f);
            this.B.setNub(this.xIndex, 0, rgb[2]);
            ++this.xIndex;
        } else {
            throw new Exception("rgb length is not equals three");
        }
    }

    public boolean regression() throws Exception {
        if (this.xIndex > 0) {
            Matrix ws = this.getLinearRegression(this.RG, this.B);
            if (ws.getX() == 1 && ws.getY() == 1) {
                this.isRegression = false;
            } else {
                this.wr = ws.getNumber(0, 0);
                this.wg = ws.getNumber(1, 0);
                this.b = ws.getNumber(2, 0);
                this.isRegression = true;
            }
            return this.isRegression;
        }
        throw new Exception("regression matrix size is zero");
    }
}

