/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyai.transFormer.nerve;

import java.util.List;
import org.dromara.easyai.i.OutBack;
import org.dromara.easyai.matrixTools.Matrix;
import org.dromara.easyai.transFormer.CodecBlock;
import org.dromara.easyai.transFormer.FirstDecoderBlock;
import org.dromara.easyai.transFormer.TransWordVector;

public class SensoryNerve {
    private final CodecBlock firstEncoderBlock;
    private final FirstDecoderBlock firstDecoderBlock;
    private final TransWordVector transWordVector;

    public SensoryNerve(CodecBlock firstEncoderBlock, FirstDecoderBlock firstDecoderBlock, TransWordVector transWordVector) throws Exception {
        this.firstEncoderBlock = firstEncoderBlock;
        this.firstDecoderBlock = firstDecoderBlock;
        this.transWordVector = transWordVector;
    }

    public void postMessage(long eventId, Matrix encoderParameter, Matrix decoderParameter, boolean isStudy, List<Integer> E, OutBack outBack, boolean outAllPro) throws Exception {
        this.firstEncoderBlock.sendInputMatrix(eventId, encoderParameter, isStudy, outBack, E, null, outAllPro);
        this.firstDecoderBlock.sendInputMatrix(eventId, decoderParameter, isStudy, outBack, E, outAllPro);
    }

    public void postSentence(long eventId, String encoderSentence, String decoderSentence, boolean isStudy, OutBack outBack) throws Exception {
        Matrix encoderFeature = this.transWordVector.getWordVector(encoderSentence, false, isStudy);
        Matrix decoderFeature = this.transWordVector.getWordVector(decoderSentence, true, isStudy);
        List<Integer> E = null;
        if (isStudy) {
            E = this.transWordVector.getE(decoderSentence);
        }
        this.postMessage(eventId, encoderFeature, decoderFeature, isStudy, E, outBack, false);
    }
}

