/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;

public class BrowseHelper {
    private BrowseHelper() {
    }

    public static CompletableFuture<List<ReferenceDescription>> browse(OpcUaClient client, BrowseDescription browseDescription) {
        return client.getSession().thenCompose(session -> BrowseHelper.browse(client.getStackClient(), session, browseDescription));
    }

    public static CompletableFuture<List<ReferenceDescription>> browse(UaStackClient client, OpcUaSession session, BrowseDescription browseDescription) {
        BrowseRequest browseRequest = new BrowseRequest(client.newRequestHeader(session.getAuthenticationToken(), client.getConfig().getRequestTimeout()), new ViewDescription(NodeId.NULL_VALUE, DateTime.MIN_VALUE, Unsigned.uint((int)0)), Unsigned.uint((int)0), new BrowseDescription[]{browseDescription});
        return ((CompletableFuture)client.sendRequest((UaRequestMessage)browseRequest).thenApply(BrowseResponse.class::cast)).thenCompose(response -> {
            BrowseResult result = response.getResults()[0];
            List<ReferenceDescription> references = Collections.synchronizedList(new ArrayList());
            return BrowseHelper.maybeBrowseNext(client, session, references, result);
        });
    }

    private static CompletableFuture<List<ReferenceDescription>> maybeBrowseNext(UaStackClient client, OpcUaSession session, List<ReferenceDescription> references, BrowseResult result) {
        if (result.getStatusCode().isGood()) {
            references.addAll(ConversionUtil.l((Object[])result.getReferences()));
            ByteString nextContinuationPoint = result.getContinuationPoint();
            if (nextContinuationPoint == null || nextContinuationPoint.isNull()) {
                return CompletableFuture.completedFuture(references);
            }
            return BrowseHelper.browseNext(client, session, nextContinuationPoint, references);
        }
        return CompletableFuture.completedFuture(references);
    }

    private static CompletableFuture<List<ReferenceDescription>> browseNext(UaStackClient client, OpcUaSession session, ByteString continuationPoint, List<ReferenceDescription> references) {
        BrowseNextRequest browseNextRequest = new BrowseNextRequest(client.newRequestHeader(session.getAuthenticationToken(), client.getConfig().getRequestTimeout()), Boolean.valueOf(false), new ByteString[]{continuationPoint});
        return ((CompletableFuture)client.sendRequest((UaRequestMessage)browseNextRequest).thenApply(BrowseNextResponse.class::cast)).thenCompose(response -> {
            BrowseResult result = response.getResults()[0];
            return BrowseHelper.maybeBrowseNext(client, session, references, result);
        });
    }
}

