/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CollectionHandler;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;

public class FlowableCollectionParser
extends BaseChildElementParser {
    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof MultiInstanceLoopCharacteristics)) {
            return;
        }
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = (MultiInstanceLoopCharacteristics)parentElement;
        CollectionHandler collectionHandler = null;
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "class"))) {
            collectionHandler = new CollectionHandler();
            collectionHandler.setImplementation(xtr.getAttributeValue(null, "class"));
            collectionHandler.setImplementationType("class");
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "delegateExpression"))) {
            collectionHandler = new CollectionHandler();
            collectionHandler.setImplementation(xtr.getAttributeValue(null, "delegateExpression"));
            collectionHandler.setImplementationType("delegateExpression");
        }
        if (collectionHandler != null) {
            BpmnXMLUtil.addXMLLocation((BaseElement)collectionHandler, xtr);
            multiInstanceLoopCharacteristics.setHandler(collectionHandler);
        }
        boolean readyWithCollection = false;
        try {
            while (!readyWithCollection && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "string".equalsIgnoreCase(xtr.getLocalName())) {
                    multiInstanceLoopCharacteristics.setCollectionString(xtr.getElementText());
                    continue;
                }
                if (xtr.isStartElement() && "expression".equalsIgnoreCase(xtr.getLocalName())) {
                    multiInstanceLoopCharacteristics.setInputDataItem(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithCollection = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing collection child elements", (Throwable)e);
        }
    }

    @Override
    public String getElementName() {
        return "collection";
    }
}

