/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.eventsubscription.service.EventSubscriptionService;

public class AbstractCaseStartEventSubscriptionCmd {
    protected String generateCorrelationConfiguration(String eventDefinitionKey, String tenantId, Map<String, Object> correlationParameterValues, CommandContext commandContext) {
        EventModel eventModel = this.getEventModel(eventDefinitionKey, tenantId, commandContext);
        HashMap<String, Object> correlationParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> correlationValue : correlationParameterValues.entrySet()) {
            this.checkEventModelCorrelationParameter(eventModel, correlationValue.getKey());
            correlationParameters.put(correlationValue.getKey(), correlationValue.getValue());
        }
        return CommandContextUtil.getEventRegistry().generateKey(correlationParameters);
    }

    protected void checkEventModelCorrelationParameter(EventModel eventModel, String correlationParameterName) {
        Collection correlationParameters = eventModel.getCorrelationParameters();
        for (EventPayload correlationParameter : correlationParameters) {
            if (!correlationParameter.getName().equals(correlationParameterName)) continue;
            return;
        }
        throw new FlowableIllegalArgumentException("There is no correlation parameter with name '" + correlationParameterName + "' defined in event model with key '" + eventModel.getKey() + "'. You can only subscribe for an event with a combination of valid correlation parameters.");
    }

    protected CaseDefinition getLatestCaseDefinitionByKey(String caseDefinitionKey, String tenantId, CommandContext commandContext) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = CommandContextUtil.getCaseDefinitionEntityManager(commandContext);
        CaseDefinitionEntity caseDefinition = null;
        if (caseDefinitionKey != null && (tenantId == null || "".equals(tenantId))) {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
            if (caseDefinition == null) {
                throw new FlowableObjectNotFoundException("No case definition found for key '" + caseDefinitionKey + "'", CaseDefinition.class);
            }
        } else if (caseDefinitionKey != null && tenantId != null && !"".equals(tenantId) && (caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId)) == null) {
            CmmnEngineConfiguration caseEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            if (caseEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = caseEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "bpmn", caseDefinitionKey);
                caseDefinition = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, defaultTenant) : caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
                if (caseDefinition == null) {
                    throw new FlowableObjectNotFoundException("No case definition found for key '" + caseDefinitionKey + "'. Fallback to default tenant was also applied.", CaseDefinition.class);
                }
            } else {
                throw new FlowableObjectNotFoundException("Case definition with key '" + caseDefinitionKey + "' and tenantId '" + tenantId + "' was not found.", CaseDefinition.class);
            }
        }
        if (caseDefinition == null) {
            throw new FlowableIllegalArgumentException("No deployed case definition found for key '" + caseDefinitionKey + "'.");
        }
        return caseDefinition;
    }

    protected CaseDefinition getCaseDefinitionById(String caseDefinitionId, CommandContext commandContext) {
        CmmnRepositoryService repositoryService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCmmnRepositoryService();
        CaseDefinition caseDefinition = (CaseDefinition)repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseDefinitionId).singleResult();
        if (caseDefinition == null) {
            throw new FlowableIllegalArgumentException("No deployed case definition found for id '" + caseDefinitionId + "'.");
        }
        return caseDefinition;
    }

    protected Case getCase(String caseDefinitionId, CommandContext commandContext) {
        CmmnRepositoryService repositoryService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCmmnRepositoryService();
        CmmnModel cmmnModel = repositoryService.getCmmnModel(caseDefinitionId);
        return cmmnModel.getPrimaryCase();
    }

    protected EventModel getEventModel(String eventDefinitionKey, String tenantId, CommandContext commandContext) {
        EventModel eventModel = CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(eventDefinitionKey, tenantId);
        if (eventModel == null) {
            throw new FlowableIllegalArgumentException("Could not find event model with key '" + eventDefinitionKey + "'.");
        }
        return eventModel;
    }

    protected String getStartCorrelationConfiguration(String caseDefinitionId, CommandContext commandContext) {
        List correlationCfgExtensions;
        CmmnModel cmmnModel = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCmmnRepositoryService().getCmmnModel(caseDefinitionId);
        if (cmmnModel != null && !(correlationCfgExtensions = cmmnModel.getPrimaryCase().getExtensionElements().getOrDefault("startEventCorrelationConfiguration", Collections.emptyList())).isEmpty()) {
            return ((ExtensionElement)correlationCfgExtensions.get(0)).getElementText();
        }
        return null;
    }

    protected EventSubscriptionService getEventSubscriptionService(CommandContext commandContext) {
        return CommandContextUtil.getCmmnEngineConfiguration(commandContext).getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
    }
}

