/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractExternalWorkerJobCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ExternalWorkerServiceTask;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class ExternalWorkerJobCompleteCmd
extends AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected Map<String, Object> variables;

    public ExternalWorkerJobCompleteCmd(String externalJobId, String workerId, Map<String, Object> variables) {
        super(externalJobId, workerId);
        this.variables = variables;
    }

    @Override
    protected void runJobLogic(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        externalWorkerJob.setJobHandlerConfiguration(null);
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        VariableServiceConfiguration variableServiceConfiguration = cmmnEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        int numberOfVariablesAdded = 0;
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(externalWorkerJob.getSubScopeId());
        ExternalWorkerServiceTask externalWorkerServiceTask = (ExternalWorkerServiceTask)planItemInstanceEntity.getPlanItemDefinition();
        List outParameters = externalWorkerServiceTask.getOutParameters();
        if (outParameters != null && !outParameters.isEmpty()) {
            VariableContainerWrapper temporaryVariableContainer = new VariableContainerWrapper(this.variables);
            for (IOParameter outParameter : outParameters) {
                Object variableValue;
                if (StringUtils.isNotEmpty((CharSequence)outParameter.getSource())) {
                    variableValue = temporaryVariableContainer.getVariable(outParameter.getSource());
                } else {
                    Expression outParameterExpression = cmmnEngineConfiguration.getExpressionManager().createExpression(outParameter.getSourceExpression());
                    variableValue = outParameterExpression.getValue((VariableContainer)temporaryVariableContainer);
                }
                this.addVariable(externalWorkerJob, variableService, outParameter.getTarget(), variableValue);
                ++numberOfVariablesAdded;
            }
        } else if (this.variables != null && !this.variables.isEmpty()) {
            for (Map.Entry<String, Object> variableEntry : this.variables.entrySet()) {
                String varName = variableEntry.getKey();
                Object varValue = variableEntry.getValue();
                this.addVariable(externalWorkerJob, variableService, varName, varValue);
            }
            numberOfVariablesAdded = this.variables.size();
        }
        if (numberOfVariablesAdded > 0 && planItemInstanceEntity instanceof CountingPlanItemInstanceEntity) {
            ((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).setVariableCount(((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).getVariableCount() + numberOfVariablesAdded);
        }
        this.moveExternalWorkerJobToExecutableJob(externalWorkerJob, commandContext);
    }

    protected void addVariable(ExternalWorkerJobEntity externalWorkerJob, VariableService variableService, String varName, Object varValue) {
        VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
        variableInstance.setScopeId(externalWorkerJob.getScopeId());
        variableInstance.setSubScopeId(externalWorkerJob.getSubScopeId());
        variableInstance.setScopeType("cmmnExternalWorker");
        variableService.insertVariableInstanceWithValue(variableInstance, varValue, externalWorkerJob.getTenantId());
    }
}

