/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.calendar.BusinessCalendarManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.job.api.Job;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class RescheduleTimerJobCmd
implements Command<Job> {
    protected String eventListenerInstanceId;
    protected String jobId;
    protected Date newDueDate;
    protected String newDateValue;

    public RescheduleTimerJobCmd(String eventListenerInstanceId, String jobId, Date newDueDate, String newDateValue) {
        this.eventListenerInstanceId = eventListenerInstanceId;
        this.jobId = jobId;
        this.newDueDate = newDueDate;
        this.newDateValue = newDateValue;
    }

    public Job execute(CommandContext commandContext) {
        String timerJobId = null;
        PlanItemInstance planItemInstance = null;
        JobService jobService = CommandContextUtil.getJobService(commandContext);
        if (this.eventListenerInstanceId != null) {
            planItemInstance = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.eventListenerInstanceId);
            if (planItemInstance == null) {
                throw new FlowableObjectNotFoundException("No plan item instance found for id " + this.eventListenerInstanceId);
            }
            List timerJobs = ((TimerJobQuery)jobService.createTimerJobQuery().planItemInstanceId(this.eventListenerInstanceId)).list();
            if (timerJobs == null || timerJobs.isEmpty()) {
                throw new FlowableException("No timer jobs found for plan item instance " + this.eventListenerInstanceId);
            }
            if (timerJobs.size() > 1) {
                throw new FlowableException("Multiple timer jobs found for plan item instance " + this.eventListenerInstanceId);
            }
            timerJobId = ((Job)timerJobs.get(0)).getId();
        } else {
            timerJobId = this.jobId;
        }
        TimerJobService timerJobService = CommandContextUtil.getTimerJobService(commandContext);
        TimerJobEntity timerJob = timerJobService.findTimerJobById(timerJobId);
        if (timerJob == null) {
            throw new FlowableObjectNotFoundException("Timer job not found for id " + timerJobId);
        }
        if (planItemInstance == null && (planItemInstance = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(timerJob.getSubScopeId())) == null) {
            throw new FlowableException("Plan item instance not found for id " + timerJob.getSubScopeId());
        }
        Date timerDueDate = null;
        boolean isRepeating = false;
        if (this.newDueDate != null) {
            timerDueDate = this.newDueDate;
        } else if (this.newDateValue != null) {
            BusinessCalendarManager businessCalendarManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getBusinessCalendarManager();
            if (this.isDurationString(this.newDateValue)) {
                timerDueDate = businessCalendarManager.getBusinessCalendar("dueDate").resolveDuedate(this.newDateValue);
            } else if (this.isRepetitionString(this.newDateValue)) {
                timerDueDate = businessCalendarManager.getBusinessCalendar("cycle").resolveDuedate(this.newDateValue);
                isRepeating = true;
            } else {
                try {
                    timerDueDate = DateTime.parse((String)this.newDateValue).toDate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    timerDueDate = businessCalendarManager.getBusinessCalendar("cycle").resolveDuedate(this.newDateValue);
                    isRepeating = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (timerDueDate == null) {
                throw new FlowableException("Timer expression '" + this.newDateValue + "' did not resolve to java.util.Date for " + planItemInstance);
            }
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        JobServiceConfiguration jobServiceConfiguration = cmmnEngineConfiguration.getJobServiceConfiguration();
        TimerJobEntity newTimer = timerJobService.createTimerJob();
        newTimer.setJobType(timerJob.getJobType());
        newTimer.setJobHandlerType(timerJob.getJobHandlerType());
        newTimer.setExclusive(true);
        newTimer.setRetries(jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
        newTimer.setDuedate(timerDueDate);
        newTimer.setScopeDefinitionId(timerJob.getScopeDefinitionId());
        newTimer.setScopeId(timerJob.getScopeId());
        newTimer.setSubScopeId(timerJob.getSubScopeId());
        newTimer.setCategory(timerJob.getCategory());
        newTimer.setScopeType(timerJob.getScopeType());
        newTimer.setElementId(timerJob.getElementId());
        newTimer.setElementName(timerJob.getElementName());
        newTimer.setTenantId(timerJob.getTenantId());
        if (isRepeating) {
            newTimer.setRepeat(this.prepareRepeat(this.newDateValue, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock()));
        }
        timerJobService.deleteTimerJob(timerJob);
        timerJobService.scheduleTimerJob(newTimer);
        return newTimer;
    }

    protected boolean isRepetitionString(String timerString) {
        return timerString != null && timerString.startsWith("R");
    }

    protected boolean isDurationString(String timerString) {
        return timerString != null && timerString.startsWith("P");
    }

    public String prepareRepeat(String dueDate, Clock clock) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            return dueDate.replace("/", "/" + fmt.print((ReadableInstant)new DateTime((Object)clock.getCurrentTime(), DateTimeZone.forTimeZone((TimeZone)clock.getCurrentTimeZone()))) + "/");
        }
        return dueDate;
    }
}

