/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CaseDefinitionQuery;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.repository.CmmnDeploymentQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CmmnDeploymentDataManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentQueryImpl;
import org.flowable.cmmn.engine.impl.util.CmmnCorrelationUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class CmmnDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<CmmnEngineConfiguration, CmmnDeploymentEntity, CmmnDeploymentDataManager>
implements CmmnDeploymentEntityManager {
    public CmmnDeploymentEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CmmnDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(CmmnDeploymentEntity deployment) {
        super.insert((Entity)deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getCmmnResourceEntityManager().insert((CmmnResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeploymentAndRelatedData(String deploymentId, boolean cascade) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = this.getCaseDefinitionEntityManager();
        List caseDefinitions = caseDefinitionEntityManager.createCaseDefinitionQuery().deploymentId(deploymentId).list();
        for (CaseDefinition caseDefinition : caseDefinitions) {
            ((CmmnEngineConfiguration)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteIdentityLinksByScopeDefinitionIdAndType(caseDefinition.getId(), "cmmn");
            ((CmmnEngineConfiguration)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().deleteEventSubscriptionsForScopeDefinitionIdAndType(caseDefinition.getId(), "cmmn");
            if (cascade) {
                caseDefinitionEntityManager.deleteCaseDefinitionAndRelatedData(caseDefinition.getId(), true);
            } else {
                caseDefinitionEntityManager.delete(caseDefinition.getId());
            }
            this.restorePreviousStartEventsIfNeeded(caseDefinition);
        }
        this.getCmmnResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete((CmmnDeploymentEntity)this.findById(deploymentId));
    }

    protected void restorePreviousStartEventsIfNeeded(CaseDefinition caseDefinition) {
        CmmnModel cmmnModel;
        Case caseModel;
        String startEventType;
        CaseDefinition previousCaseDefinition;
        CaseDefinitionEntity latestCaseDefinition = this.findLatestCaseDefinition(caseDefinition);
        if (latestCaseDefinition != null && caseDefinition.getId().equals(latestCaseDefinition.getId()) && (previousCaseDefinition = this.findNewLatestCaseDefinitionAfterRemovalOf(caseDefinition)) != null && (startEventType = (caseModel = (cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinition.getId())).getPrimaryCase()).getStartEventType()) != null) {
            this.restoreEventRegistryStartEvent(previousCaseDefinition, caseModel, startEventType);
        }
    }

    protected void restoreEventRegistryStartEvent(CaseDefinition previousCaseDefinition, Case caseModel, String startEventType) {
        ((CmmnEngineConfiguration)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(startEventType).configuration(CmmnCorrelationUtil.getCorrelationKey("eventCorrelationParameter", CommandContextUtil.getCommandContext(), (BaseElement)caseModel)).scopeDefinitionId(previousCaseDefinition.getId()).scopeType("cmmn").tenantId(previousCaseDefinition.getTenantId()).create();
    }

    protected CaseDefinitionEntity findLatestCaseDefinition(CaseDefinition caseDefinition) {
        CaseDefinitionEntity latestCaseDefinition = null;
        latestCaseDefinition = caseDefinition.getTenantId() != null && !"".equals(caseDefinition.getTenantId()) ? this.getCaseDefinitionEntityManager().findLatestCaseDefinitionByKeyAndTenantId(caseDefinition.getKey(), caseDefinition.getTenantId()) : this.getCaseDefinitionEntityManager().findLatestCaseDefinitionByKey(caseDefinition.getKey());
        return latestCaseDefinition;
    }

    protected CaseDefinition findNewLatestCaseDefinitionAfterRemovalOf(CaseDefinition caseDefinitionToBeRemoved) {
        CaseDefinitionQuery query = this.getCaseDefinitionEntityManager().createCaseDefinitionQuery();
        query.caseDefinitionKey(caseDefinitionToBeRemoved.getKey());
        if (caseDefinitionToBeRemoved.getTenantId() != null && !"".equals(caseDefinitionToBeRemoved.getTenantId())) {
            query.caseDefinitionTenantId(caseDefinitionToBeRemoved.getTenantId());
        } else {
            query.caseDefinitionWithoutTenantId();
        }
        if (caseDefinitionToBeRemoved.getVersion() > 0) {
            query.caseDefinitionVersionLowerThan(Integer.valueOf(caseDefinitionToBeRemoved.getVersion()));
        }
        query.orderByCaseDefinitionVersion().desc();
        List caseDefinitions = query.listPage(0, 1);
        if (caseDefinitions != null && caseDefinitions.size() > 0) {
            return (CaseDefinition)caseDefinitions.get(0);
        }
        return null;
    }

    @Override
    public CmmnDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return ((CmmnDeploymentDataManager)this.dataManager).findLatestDeploymentByName(deploymentName);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((CmmnDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public CmmnDeploymentQuery createDeploymentQuery() {
        return new CmmnDeploymentQueryImpl(((CmmnEngineConfiguration)this.engineConfiguration).getCommandExecutor());
    }

    @Override
    public List<CmmnDeployment> findDeploymentsByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return ((CmmnDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return ((CmmnDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    protected CmmnResourceEntityManager getCmmnResourceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCmmnResourceEntityManager();
    }

    protected CaseDefinitionEntityManager getCaseDefinitionEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCaseDefinitionEntityManager();
    }
}

