/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.data.AbstractCmmnDataManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.PlanItemInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryImpl;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcherAdapter;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.Entity;

public class MybatisPlanItemInstanceDataManagerImpl
extends AbstractCmmnDataManager<PlanItemInstanceEntity>
implements PlanItemInstanceDataManager {
    protected PlanItemInstanceByCaseInstanceIdCachedEntityMatcher planItemInstanceByCaseInstanceIdCachedEntityMatcher = new PlanItemInstanceByCaseInstanceIdCachedEntityMatcher();
    protected PlanItemInstanceByCaseInstanceIdAndPlanItemIdCachedEntityMatcher planItemInstanceByCaseInstanceIdAndPlanItemIdCachedEntityMatcher = new PlanItemInstanceByCaseInstanceIdAndPlanItemIdCachedEntityMatcher();
    protected PlanItemInstanceByStageInstanceIdAndPlanItemIdCachedEntityMatcher planItemInstanceByStageInstanceIdAndPlanItemIdCachedEntityMatcher = new PlanItemInstanceByStageInstanceIdAndPlanItemIdCachedEntityMatcher();
    protected PlanItemInstanceByStagePlanItemInstanceIdCachedEntityMatcher planItemInstanceByStagePlanItemInstanceIdCachedEntityMatcher = new PlanItemInstanceByStagePlanItemInstanceIdCachedEntityMatcher();

    public MybatisPlanItemInstanceDataManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(cmmnEngineConfiguration);
    }

    public Class<? extends PlanItemInstanceEntity> getManagedEntityClass() {
        return PlanItemInstanceEntityImpl.class;
    }

    public PlanItemInstanceEntity create() {
        PlanItemInstanceEntityImpl planItemInstanceEntityImpl = new PlanItemInstanceEntityImpl();
        planItemInstanceEntityImpl.setChildPlanItemInstances(new ArrayList<PlanItemInstanceEntity>(1));
        planItemInstanceEntityImpl.setSatisfiedSentryPartInstances(new ArrayList<SentryPartInstanceEntity>(1));
        planItemInstanceEntityImpl.internalSetVariableInstances(new HashMap());
        return planItemInstanceEntityImpl;
    }

    public PlanItemInstanceEntity findById(String planItemInstanceId) {
        EntityCache entityCache = this.getEntityCache();
        PlanItemInstanceEntity cachedPlanItemInstanceEntity = (PlanItemInstanceEntity)entityCache.findInCache(this.getManagedEntityClass(), planItemInstanceId);
        if (cachedPlanItemInstanceEntity != null) {
            return cachedPlanItemInstanceEntity;
        }
        this.cmmnEngineConfiguration.getCaseInstanceDataManager().findCaseInstanceEntityEagerFetchPlanItemInstances(null, planItemInstanceId);
        return (PlanItemInstanceEntity)super.findById(planItemInstanceId);
    }

    @Override
    public List<PlanItemInstanceEntity> findByCaseInstanceId(String caseInstanceId) {
        return this.getList("selectPlanItemInstancesByCaseInstanceId", caseInstanceId, (CachedEntityMatcher)this.planItemInstanceByCaseInstanceIdCachedEntityMatcher, true);
    }

    @Override
    public List<PlanItemInstanceEntity> findByStagePlanItemInstanceId(String stagePlanItemInstanceId) {
        return this.getList("selectPlanItemInstancesByStagePlanItemInstanceId", stagePlanItemInstanceId, (CachedEntityMatcher)this.planItemInstanceByStagePlanItemInstanceIdCachedEntityMatcher, true);
    }

    @Override
    public List<PlanItemInstanceEntity> findByCaseInstanceIdAndPlanItemId(String caseInstanceId, String planitemId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caseInstanceId", caseInstanceId);
        params.put("planItemId", planitemId);
        return this.getList("selectPlanItemInstancesByCaseInstanceIdAndPlanItemId", params, (CachedEntityMatcher)this.planItemInstanceByCaseInstanceIdAndPlanItemIdCachedEntityMatcher);
    }

    @Override
    public List<PlanItemInstanceEntity> findByStageInstanceIdAndPlanItemId(String stageInstanceId, String planItemId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stageInstanceId", stageInstanceId);
        params.put("planItemId", planItemId);
        return this.getList("selectPlanItemInstancesByStageInstanceIdAndPlanItemId", params, (CachedEntityMatcher)this.planItemInstanceByStageInstanceIdAndPlanItemIdCachedEntityMatcher);
    }

    @Override
    public long countByCriteria(PlanItemInstanceQueryImpl planItemInstanceQuery) {
        this.setSafeInValueLists(planItemInstanceQuery);
        return (Long)this.getDbSqlSession().selectOne("selectPlanItemInstanceCountByQueryCriteria", (Object)planItemInstanceQuery);
    }

    @Override
    public List<PlanItemInstance> findByCriteria(PlanItemInstanceQueryImpl planItemInstanceQuery) {
        this.setSafeInValueLists(planItemInstanceQuery);
        return this.getDbSqlSession().selectList("selectPlanItemInstancesByQueryCriteria", (ListQueryParameterObject)planItemInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public List<PlanItemInstance> findWithVariablesByCriteria(PlanItemInstanceQueryImpl planItemInstanceQuery) {
        this.setSafeInValueLists(planItemInstanceQuery);
        return this.getDbSqlSession().selectList("selectPlanItemInstancesWithLocalVariablesByQueryCriteria", (ListQueryParameterObject)planItemInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public void deleteByCaseDefinitionId(String caseDefinitionId) {
        this.getDbSqlSession().delete("deletePlanItemInstanceByCaseDefinitionId", (Object)caseDefinitionId, this.getManagedEntityClass());
    }

    @Override
    public void deleteByStageInstanceId(String stageInstanceId) {
        List planItemInstanceEntities = this.getEntityCache().findInCache(PlanItemInstanceEntityImpl.class);
        for (PlanItemInstanceEntityImpl planItemInstanceEntity : planItemInstanceEntities) {
            if (!stageInstanceId.equals(planItemInstanceEntity.getStageInstanceId())) continue;
            this.getDbSqlSession().delete((Entity)planItemInstanceEntity);
        }
        this.getDbSqlSession().delete("deletePlanItemInstancesByStageInstanceId", (Object)stageInstanceId, this.getManagedEntityClass());
    }

    @Override
    public void deleteByCaseInstanceId(String caseInstanceId) {
        this.bulkDelete("deletePlanItemInstancesByCaseInstanceId", (CachedEntityMatcher)this.planItemInstanceByCaseInstanceIdCachedEntityMatcher, caseInstanceId);
    }

    protected void setSafeInValueLists(PlanItemInstanceQueryImpl planItemInstanceQuery) {
        if (planItemInstanceQuery.getInvolvedGroups() != null) {
            planItemInstanceQuery.setSafeInvolvedGroups(this.createSafeInValuesList(planItemInstanceQuery.getInvolvedGroups()));
        }
        if (planItemInstanceQuery.getOrQueryObjects() != null && !planItemInstanceQuery.getOrQueryObjects().isEmpty()) {
            for (PlanItemInstanceQueryImpl oInstanceQuery : planItemInstanceQuery.getOrQueryObjects()) {
                this.setSafeInValueLists(oInstanceQuery);
            }
        }
    }

    public static class PlanItemInstanceByCaseInstanceIdCachedEntityMatcher
    extends CachedEntityMatcherAdapter<PlanItemInstanceEntity> {
        public boolean isRetained(PlanItemInstanceEntity entity, Object param) {
            String caseInstanceId = (String)param;
            return caseInstanceId.equals(entity.getCaseInstanceId());
        }
    }

    public static class PlanItemInstanceByCaseInstanceIdAndPlanItemIdCachedEntityMatcher
    extends CachedEntityMatcherAdapter<PlanItemInstanceEntity> {
        public boolean isRetained(PlanItemInstanceEntity entity, Object param) {
            Map map = (Map)param;
            String caseInstanceId = (String)map.get("caseInstanceId");
            String planItemId = (String)map.get("planItemId");
            return caseInstanceId.equals(entity.getCaseInstanceId()) && entity.getPlanItem() != null && planItemId.equals(entity.getPlanItem().getId());
        }
    }

    public static class PlanItemInstanceByStageInstanceIdAndPlanItemIdCachedEntityMatcher
    extends CachedEntityMatcherAdapter<PlanItemInstanceEntity> {
        public boolean isRetained(PlanItemInstanceEntity entity, Object param) {
            Map map = (Map)param;
            String stageInstanceId = (String)map.get("stageInstanceId");
            String planItemId = (String)map.get("planItemId");
            return stageInstanceId.equals(entity.getStageInstanceId()) && entity.getPlanItem() != null && planItemId.equals(entity.getPlanItem().getId());
        }
    }

    public static class PlanItemInstanceByStagePlanItemInstanceIdCachedEntityMatcher
    extends CachedEntityMatcherAdapter<PlanItemInstanceEntity> {
        public boolean isRetained(PlanItemInstanceEntity entity, Object param) {
            String stagePlanItemInstanceId = (String)param;
            return stagePlanItemInstanceId.equals(entity.getStageInstanceId());
        }
    }
}

