/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring;

import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.spring.SpringCmmnEngineConfiguration;
import org.flowable.cmmn.spring.SpringCmmnExpressionManager;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CmmnEngineFactoryBean
implements FactoryBean<CmmnEngine>,
DisposableBean,
ApplicationContextAware {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected CmmnEngine cmmnEngine;

    public void destroy() throws Exception {
        if (this.cmmnEngine != null) {
            this.cmmnEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public CmmnEngine getObject() throws Exception {
        this.configureExpressionManager();
        this.configureExternallyManagedTransactions();
        this.cmmnEngine = this.cmmnEngineConfiguration.buildCmmnEngine();
        return this.cmmnEngine;
    }

    protected void configureExpressionManager() {
        if (this.cmmnEngineConfiguration.getExpressionManager() == null && this.applicationContext != null) {
            this.cmmnEngineConfiguration.setExpressionManager((ExpressionManager)new SpringCmmnExpressionManager(this.applicationContext, this.cmmnEngineConfiguration.getBeans()));
        }
    }

    protected void configureExternallyManagedTransactions() {
        SpringCmmnEngineConfiguration engineConfiguration;
        if (this.cmmnEngineConfiguration instanceof SpringCmmnEngineConfiguration && (engineConfiguration = (SpringCmmnEngineConfiguration)this.cmmnEngineConfiguration).getTransactionManager() != null) {
            this.cmmnEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<CmmnEngine> getObjectType() {
        return CmmnEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public CmmnEngineConfiguration getCmmnEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public void setCmmnEngineConfiguration(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }
}

