/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.deploy;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DecisionQueryImpl;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.Deployer;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;

public class DeploymentManager {
    protected DmnEngineConfiguration engineConfig;
    protected DeploymentCache<DecisionCacheEntry> decisionCache;
    protected List<Deployer> deployers;
    protected DecisionEntityManager decisionEntityManager;
    protected DmnDeploymentEntityManager deploymentEntityManager;

    public DeploymentManager(DeploymentCache<DecisionCacheEntry> decisionCache, DmnEngineConfiguration engineConfig) {
        this.decisionCache = decisionCache;
        this.engineConfig = engineConfig;
    }

    public void deploy(DmnDeploymentEntity deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(DmnDeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public DecisionEntity findDeployedDecisionById(String decisionId) {
        DecisionEntity decision;
        if (decisionId == null) {
            throw new FlowableException("Invalid decision id : null");
        }
        DecisionCacheEntry cacheEntry = (DecisionCacheEntry)this.decisionCache.get(decisionId);
        DecisionEntity decisionEntity = decision = cacheEntry != null ? cacheEntry.getDecisionEntity() : null;
        if (decision == null) {
            decision = (DecisionEntity)this.engineConfig.getDecisionEntityManager().findById(decisionId);
            if (decision == null) {
                throw new FlowableObjectNotFoundException("no decision found with id '" + decisionId + "'");
            }
            decision = this.resolveDecision(decision).getDecisionEntity();
        }
        return decision;
    }

    public DecisionEntity findDeployedLatestDefinitionByKey(String definitionKey) {
        DecisionEntity definition = this.decisionEntityManager.findLatestDecisionByKey(definitionKey);
        if (definition == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + definitionKey + "'");
        }
        definition = this.resolveDecision(definition).getDecisionEntity();
        return definition;
    }

    public DecisionEntity findDeployedLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        DecisionEntity definition = this.decisionEntityManager.findLatestDecisionByKeyAndTenantId(definitionKey, tenantId);
        if (definition == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + definitionKey + "' for tenant identifier '" + tenantId + "'");
        }
        definition = this.resolveDecision(definition).getDecisionEntity();
        return definition;
    }

    public DecisionEntity findDeployedLatestDecisionByKeyAndDeploymentId(String definitionKey, String deploymentId) {
        DecisionEntity definition = this.decisionEntityManager.findDecisionByDeploymentAndKey(deploymentId, definitionKey);
        if (definition == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + definitionKey + "' for deployment id '" + deploymentId + "'");
        }
        definition = this.resolveDecision(definition).getDecisionEntity();
        return definition;
    }

    public DecisionEntity findDeployedLatestDecisionByKeyDeploymentIdAndTenantId(String definitionKey, String deploymentId, String tenantId) {
        DecisionEntity definition = this.decisionEntityManager.findDecisionByDeploymentAndKeyAndTenantId(deploymentId, definitionKey, tenantId);
        if (definition == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + definitionKey + "' for deployment id '" + deploymentId + "' and tenant identifier " + tenantId);
        }
        definition = this.resolveDecision(definition).getDecisionEntity();
        return definition;
    }

    public DecisionEntity findDeployedDefinitionByKeyAndVersionAndTenantId(String definitionKey, int definitionVersion, String tenantId) {
        DecisionEntity definition = this.decisionEntityManager.findDecisionByKeyAndVersionAndTenantId(definitionKey, definitionVersion, tenantId);
        if (definition == null) {
            throw new FlowableObjectNotFoundException("no decision deployed with key = '" + definitionKey + "' and version = '" + definitionVersion + "'");
        }
        definition = this.resolveDecision(definition).getDecisionEntity();
        return definition;
    }

    public DecisionCacheEntry resolveDecision(DmnDecision decision) {
        String decisionId = decision.getId();
        String deploymentId = decision.getDeploymentId();
        DecisionCacheEntry cachedDecision = (DecisionCacheEntry)this.decisionCache.get(decisionId);
        if (cachedDecision == null) {
            DmnDeploymentEntity deployment = (DmnDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<DmnResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (DmnResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment, null);
            cachedDecision = deployment.getDecisionCacheEntry(decisionId);
            if (cachedDecision == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put decision '" + decisionId + "' in the cache");
            }
        }
        return cachedDecision;
    }

    public void removeDeployment(String deploymentId) {
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        List definitions = new DecisionQueryImpl().deploymentId(deploymentId).list();
        this.deploymentEntityManager.deleteDeployment(deploymentId);
        for (DmnDecision definition : definitions) {
            this.decisionCache.remove(definition.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<DecisionCacheEntry> getDecisionCache() {
        return this.decisionCache;
    }

    public void setDecisionCache(DeploymentCache<DecisionCacheEntry> decisionCache) {
        this.decisionCache = decisionCache;
    }

    public DecisionEntityManager getDecisionEntityManager() {
        return this.decisionEntityManager;
    }

    public void setDecisionEntityManager(DecisionEntityManager decisionEntityManager) {
        this.decisionEntityManager = decisionEntityManager;
    }

    public DmnDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(DmnDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

