/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.FlowableVersion;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbUpgradeStep;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.db.SchemaManagerDatabaseConfiguration;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlScriptBasedDbSchemaManager
implements SchemaManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    protected static final String PROPERTY_TABLE = "ACT_GE_PROPERTY";

    protected SchemaManagerDatabaseConfiguration getDatabaseConfiguration() {
        return Context.getCommandContext().getSession(SchemaManagerDatabaseConfiguration.class);
    }

    protected void dbSchemaUpgradeUntil6120(String component, int currentDatabaseVersionsIndex, String dbVersion) {
        FlowableVersion version = FlowableVersions.FLOWABLE_VERSIONS.get(currentDatabaseVersionsIndex);
        Object currentVersion = version.getMainVersion();
        this.logger.info("upgrading flowable {} schema from {} to {}", new Object[]{component, currentVersion, "6.1.2.0"});
        SchemaManagerDatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration();
        for (int i = currentDatabaseVersionsIndex + 1; i < FlowableVersions.getFlowableVersionIndexForDbVersion("6.1.2.0"); ++i) {
            Object nextVersion = FlowableVersions.FLOWABLE_VERSIONS.get(i).getMainVersion();
            if (((String)nextVersion).endsWith("-SNAPSHOT")) {
                nextVersion = ((String)nextVersion).substring(0, ((String)nextVersion).length() - "-SNAPSHOT".length());
            }
            currentVersion = ((String)currentVersion).replace("cam", "");
            currentVersion = ((String)currentVersion).replace(".", "");
            if ("fox".equalsIgnoreCase(dbVersion) && FlowableVersions.hasCamMigrationVersion((String)nextVersion)) {
                nextVersion = "cam" + (String)nextVersion;
            }
            nextVersion = ((String)nextVersion).replace(".", "");
            this.logger.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{currentVersion, nextVersion, component});
            String databaseType = databaseConfiguration.getDatabaseType();
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + (String)currentVersion + ".to." + (String)nextVersion, component, databaseType), true);
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + (String)currentVersion + ".to." + (String)nextVersion, component, "all"), true);
            currentVersion = nextVersion;
        }
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex, String engineDbVersion) {
        FlowableVersion version = FlowableVersions.FLOWABLE_VERSIONS.get(currentDatabaseVersionsIndex);
        Object currentVersion = version.getMainVersion();
        this.logger.info("upgrading flowable {} schema from {} to {}", new Object[]{component, currentVersion, "7.1.0.2"});
        for (int i = currentDatabaseVersionsIndex + 1; i < FlowableVersions.FLOWABLE_VERSIONS.size(); ++i) {
            Object nextVersion = FlowableVersions.FLOWABLE_VERSIONS.get(i).getMainVersion();
            if (((String)nextVersion).endsWith("-SNAPSHOT")) {
                nextVersion = ((String)nextVersion).substring(0, ((String)nextVersion).length() - "-SNAPSHOT".length());
            }
            currentVersion = ((String)currentVersion).replace("cam", "");
            currentVersion = ((String)currentVersion).replace(".", "");
            if ("fox".equalsIgnoreCase(engineDbVersion) && FlowableVersions.hasCamMigrationVersion((String)nextVersion)) {
                nextVersion = "cam" + (String)nextVersion;
            }
            nextVersion = ((String)nextVersion).replace(".", "");
            this.logger.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{currentVersion, nextVersion, component});
            String databaseType = this.getDatabaseConfiguration().getDatabaseType();
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + (String)currentVersion + ".to." + (String)nextVersion, component, databaseType), true);
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + (String)currentVersion + ".to." + (String)nextVersion, component, "all"), true);
            currentVersion = nextVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        SchemaManagerDatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration();
        if (!databaseConfiguration.isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = databaseConfiguration.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String catalog = databaseConfiguration.getDatabaseCatalog();
        String schema = databaseConfiguration.getDatabaseSchema();
        String databaseType = databaseConfiguration.getDatabaseType();
        if ("postgres".equals(databaseType)) {
            tableName = tableName.toLowerCase();
        } else if ("cockroachdb".equals(databaseType)) {
            tableName = tableName.toLowerCase();
            schema = "public";
        }
        if (schema != null && "oracle".equals(databaseType)) {
            schema = schema.toUpperCase();
        }
        if (catalog != null && catalog.length() == 0) {
            catalog = null;
        }
        try {
            tables = databaseMetaData.getTables(catalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (tables != null) {
                        tables.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlowableException("couldn't check if tables are already present using metadata: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (tables != null) {
                tables.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.getDatabaseConfiguration().getDatabaseTablePrefix() + tableName;
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProperty(String propertyName, boolean checkPropertyTablePresent) {
        String tableName = this.getPropertyTable();
        if (checkPropertyTablePresent && !this.isTablePresent(tableName)) {
            return null;
        }
        SchemaManagerDatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration();
        if (!databaseConfiguration.isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        try (PreparedStatement statement = databaseConfiguration.getConnection().prepareStatement("select VALUE_ from " + tableName + " where NAME_ = ?");){
            statement.setString(1, propertyName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            if (!checkPropertyTablePresent && this.isMissingTablesException(e)) {
                throw new FlowableException("SQL Exception when getting value. Message: " + e.getMessage(), (Throwable)e);
            }
            this.logger.error("Could not get property from table {}", (Object)tableName, (Object)e);
            return null;
        }
    }

    protected String getPropertyTable() {
        return PROPERTY_TABLE;
    }

    public String getResourceForDbOperation(String directory, String operation, String component, String databaseType) {
        return this.getResourcesRootDirectory() + directory + "/flowable." + databaseType + "." + operation + "." + component + ".sql";
    }

    protected abstract String getResourcesRootDirectory();

    public void executeMandatorySchemaResource(String operation, String component) {
        String databaseType = this.getDatabaseConfiguration().getDatabaseType();
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component, databaseType), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) {
                    throw new FlowableException("resource '" + resourceName + "' is not available");
                }
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        this.logger.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            SchemaManagerDatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration();
            Connection connection = databaseConfiguration.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes, StandardCharsets.UTF_8);
            String databaseType = databaseConfiguration.getDatabaseType();
            try {
                if ("mysql".equals(databaseType)) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    this.logger.info("Found MySQL: majorVersion={} minorVersion={}", (Object)majorVersion, (Object)minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                this.logger.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            boolean inOraclePlsqlBlock = false;
            while (line != null) {
                if (line.startsWith("# ")) {
                    this.logger.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    if ("-- force-commit".equals(line)) {
                        connection.commit();
                        this.logger.debug("Forcing commit");
                    } else {
                        this.logger.debug(line.substring(3));
                    }
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (FlowableException e) {
                            throw new FlowableException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            this.logger.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute();
                        }
                        catch (Exception e) {
                            throw new FlowableException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (line.length() > 0) {
                        if ("oracle".equals(databaseType) && line.startsWith("begin")) {
                            inOraclePlsqlBlock = true;
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        } else if (line.endsWith(";") && !inOraclePlsqlBlock || line.startsWith("/") && inOraclePlsqlBlock) {
                            if (inOraclePlsqlBlock) {
                                inOraclePlsqlBlock = false;
                            } else {
                                sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            }
                            try (Statement jdbcStatement = connection.createStatement();){
                                this.logger.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                this.logger.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            this.logger.debug("flowable db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't " + operation + " db schema: " + exceptionSqlStatement, (Throwable)e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.contains("Table") && exceptionMessage.contains("not found")) {
                return true;
            }
            if ((exceptionMessage.contains("Table") || exceptionMessage.contains("table")) && exceptionMessage.contains("doesn't exist")) {
                return true;
            }
            if ((exceptionMessage.contains("relation") || exceptionMessage.contains("table")) && exceptionMessage.contains("does not exist")) {
                return true;
            }
        }
        return false;
    }
}

