/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.FormAwareConverter;
import org.flowable.editor.language.json.converter.FormKeyAwareConverter;
import org.flowable.editor.language.json.model.ModelInfo;

public class StartEventJsonConverter
extends BaseBpmnJsonConverter
implements FormAwareConverter,
FormKeyAwareConverter {
    protected Map<String, String> formMap;
    protected Map<String, ModelInfo> formKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        StartEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        StartEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartNoneEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartTimerEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartConditionalEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartErrorEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartEscalationEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartMessageEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartEventRegistryEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartSignalEvent", StartEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(StartEvent.class, StartEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        String eventType;
        Event event = (Event)baseElement;
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ConditionalEventDefinition) {
                return "StartConditionalEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof EscalationEventDefinition) {
                return "StartEscalationEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        } else if (event.getExtensionElements().get("eventType") != null && ((List)event.getExtensionElements().get("eventType")).size() > 0 && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)((List)event.getExtensionElements().get("eventType")).get(0)).getElementText()))) {
            return "StartEventRegistryEvent";
        }
        return "StartNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        StartEvent startEvent = (StartEvent)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            propertiesNode.put("initiator", startEvent.getInitiator());
        }
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            if (this.formKeyMap != null && this.formKeyMap.containsKey(startEvent.getFormKey())) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                ModelInfo modelInfo = this.formKeyMap.get(startEvent.getFormKey());
                formRefNode.put("id", modelInfo.getId());
                formRefNode.put("name", modelInfo.getName());
                formRefNode.put("key", modelInfo.getKey());
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", startEvent.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("formfieldvalidation", startEvent.getValidateFormFields(), propertiesNode);
        if (startEvent.getSubProcess() instanceof EventSubProcess && !startEvent.isInterrupting()) {
            propertiesNode.put("interrupting", false);
        } else {
            propertiesNode.put("interrupting", true);
        }
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
        this.addEventRegistryProperties(startEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        String eventKey;
        StartEvent startEvent = new StartEvent();
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                startEvent.setFormKey(formKey);
            } else {
                JsonNode formReferenceNode = this.getProperty("formreference", elementNode);
                if (formReferenceNode != null && formReferenceNode.get("id") != null && this.formMap != null && this.formMap.containsKey(formReferenceNode.get("id").asText())) {
                    startEvent.setFormKey(this.formMap.get(formReferenceNode.get("id").asText()));
                }
            }
            String validateFormFields = this.getPropertyValueAsString("formfieldvalidation", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)validateFormFields)) {
                startEvent.setValidateFormFields(validateFormFields);
            }
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartConditionalEvent".equals(stencilId)) {
            this.convertJsonToConditionalDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartEscalationEvent".equals(stencilId)) {
            this.convertJsonToEscalationDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        } else if ("StartEventRegistryEvent".equals(stencilId) && StringUtils.isNotEmpty((CharSequence)(eventKey = this.getPropertyValueAsString("eventkey", elementNode)))) {
            this.addFlowableExtensionElementWithValue("eventType", eventKey, (FlowElement)startEvent);
            this.addFlowableExtensionElementWithValue("eventName", this.getPropertyValueAsString("eventname", elementNode), (FlowElement)startEvent);
            this.convertJsonToOutParameters(elementNode, (Event)startEvent);
            this.convertJsonToCorrelationParameters(elementNode, "eventCorrelationParameter", (FlowElement)startEvent);
            this.addFlowableExtensionElementWithValue("channelKey", this.getPropertyValueAsString("channelkey", elementNode), (FlowElement)startEvent);
            this.addFlowableExtensionElementWithValue("channelName", this.getPropertyValueAsString("channelname", elementNode), (FlowElement)startEvent);
            this.addFlowableExtensionElementWithValue("channelType", this.getPropertyValueAsString("channeltype", elementNode), (FlowElement)startEvent);
            this.addFlowableExtensionElementWithValue("channelDestination", this.getPropertyValueAsString("channeldestination", elementNode), (FlowElement)startEvent);
            String fixedValue = this.getPropertyValueAsString("keydetectionfixedvalue", elementNode);
            String jsonField = this.getPropertyValueAsString("keydetectionjsonfield", elementNode);
            String jsonPointer = this.getPropertyValueAsString("keydetectionjsonpointer", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)fixedValue)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "fixedValue", (FlowElement)startEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", fixedValue, (FlowElement)startEvent);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonField)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonField", (FlowElement)startEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonField, (FlowElement)startEvent);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonPointer)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonPointer", (FlowElement)startEvent);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonPointer, (FlowElement)startEvent);
            }
        }
        if (!this.getPropertyValueAsBoolean("interrupting", elementNode)) {
            startEvent.setInterrupting(false);
        }
        return startEvent;
    }

    @Override
    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    @Override
    public void setFormKeyMap(Map<String, ModelInfo> formKeyMap) {
        this.formKeyMap = formKeyMap;
    }

    protected void addEventRegistryProperties(StartEvent startEvent, ObjectNode propertiesNode) {
        String eventType = this.getExtensionValue("eventType", (FlowElement)startEvent);
        if (StringUtils.isNotEmpty((CharSequence)eventType)) {
            this.setPropertyValue("eventkey", eventType, propertiesNode);
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", (FlowElement)startEvent), propertiesNode);
            this.addEventOutParameters((List)startEvent.getExtensionElements().get("eventOutParameter"), propertiesNode);
            this.addEventCorrelationParameters((List)startEvent.getExtensionElements().get("eventCorrelationParameter"), propertiesNode);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", (FlowElement)startEvent), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", (FlowElement)startEvent), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", (FlowElement)startEvent), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", (FlowElement)startEvent), propertiesNode);
            String keyDetectionType = this.getExtensionValue("keyDetectionType", (FlowElement)startEvent);
            String keyDetectionValue = this.getExtensionValue("keyDetectionValue", (FlowElement)startEvent);
            if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
                if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionfixedvalue", keyDetectionValue, propertiesNode);
                } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonfield", keyDetectionValue, propertiesNode);
                } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonpointer", keyDetectionValue, propertiesNode);
                }
            }
        }
    }

    protected String getExtensionValue(String name, FlowElement flowElement) {
        List extensionElements = (List)flowElement.getExtensionElements().get(name);
        if (extensionElements != null && extensionElements.size() > 0) {
            return ((ExtensionElement)extensionElements.get(0)).getElementText();
        }
        return null;
    }

    @Override
    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }
}

