/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.repository.ServerConfigRepository;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractClientResource {
    private static final String SERVER_ID = "serverId";
    @Autowired
    protected ServerConfigRepository configRepository;

    protected ServerConfig retrieveServerConfig(EndpointType endpointType) {
        List serverConfigs = this.configRepository.getByEndpointType(endpointType);
        if (serverConfigs == null) {
            throw new BadRequestException("No server config found");
        }
        if (serverConfigs.size() > 1) {
            throw new BadRequestException("Only one server config per endpoint type allowed");
        }
        return (ServerConfig)serverConfigs.get(0);
    }

    protected Map<String, String[]> getRequestParametersWithoutServerId(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>(parameterMap);
        resultMap.remove(SERVER_ID);
        return resultMap;
    }
}

