/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.CaseDefinitionService;
import org.flowable.ui.admin.service.engine.CaseInstanceService;
import org.flowable.ui.admin.service.engine.CmmnJobService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaseDefinitionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseDefinitionClientResource.class);
    @Autowired
    protected CaseDefinitionService clientService;
    @Autowired
    protected CaseInstanceService caseInstanceService;
    @Autowired
    protected CmmnJobService jobService;
    @Autowired
    protected ObjectMapper objectMapper;

    @GetMapping(value={"/rest/admin/case-definitions/{definitionId}"}, produces={"application/json"})
    public JsonNode getCaseDefinition(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.clientService.getCaseDefinition(serverConfig, definitionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting case definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-definitions/{definitionId}/case-instances"}, produces={"application/json"})
    public JsonNode getProcessInstances(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            ObjectNode bodyNode = this.objectMapper.createObjectNode();
            bodyNode.put("caseDefinitionId", definitionId);
            return this.caseInstanceService.listCaseInstancesForCaseDefinition(bodyNode, serverConfig);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting case instances for case definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }

    @GetMapping(value={"/rest/admin/case-definitions/{definitionId}/jobs"}, produces={"application/json"})
    public JsonNode getJobs(@PathVariable String definitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.CMMN);
        try {
            return this.jobService.listJobs(serverConfig, Collections.singletonMap("caseDefinitionId", new String[]{definitionId}));
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting jobs for case definition {}", (Object)definitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

