/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ProcessDefinitionService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionsClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionsClientResource.class);
    @Autowired
    protected ProcessDefinitionService clientService;

    @GetMapping(value={"/rest/admin/process-definitions"}, produces={"application/json"})
    public JsonNode listProcessDefinitions(HttpServletRequest request) {
        LOGGER.debug("REST request to get a list of process definitions");
        JsonNode resultNode = null;
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        Map<String, String[]> parameterMap = this.getRequestParametersWithoutServerId(request);
        try {
            resultNode = this.clientService.listProcesDefinitions(serverConfig, parameterMap, true);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting process definitions", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }
}

