/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.TaskService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TasksClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TasksClientResource.class);
    @Autowired
    protected TaskService clientService;

    @PostMapping(value={"/rest/admin/tasks"}, produces={"application/json"})
    public JsonNode listTasks(@RequestBody ObjectNode requestNode) {
        JsonNode resultNode;
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
        try {
            resultNode = this.clientService.listTasks(serverConfig, requestNode);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting tasks", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }
}

